/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.client.ApiClient;
import co.permify.sdk.model.Entity;
import co.permify.sdk.model.Subject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"entity", "relation", "subject"})
public class Tuple {
    public static final String JSON_PROPERTY_ENTITY = "entity";
    @Nullable
    private Entity entity;
    public static final String JSON_PROPERTY_RELATION = "relation";
    @Nullable
    private String relation;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    @Nullable
    private Subject subject;

    public Tuple entity(@Nullable Entity entity) {
        this.entity = entity;
        return this;
    }

    @Nullable
    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Entity getEntity() {
        return this.entity;
    }

    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntity(@Nullable Entity entity) {
        this.entity = entity;
    }

    public Tuple relation(@Nullable String relation) {
        this.relation = relation;
        return this;
    }

    @Nullable
    @JsonProperty(value="relation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRelation() {
        return this.relation;
    }

    @JsonProperty(value="relation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelation(@Nullable String relation) {
        this.relation = relation;
    }

    public Tuple subject(@Nullable Subject subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Subject getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(@Nullable Subject subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        return Objects.equals(this.entity, tuple.entity) && Objects.equals(this.relation, tuple.relation) && Objects.equals(this.subject, tuple.subject);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.relation, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Tuple {\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    relation: ").append(this.toIndentedString(this.relation)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getEntity() != null) {
            joiner.add(this.getEntity().toUrlQueryString((String)prefix + JSON_PROPERTY_ENTITY + suffix));
        }
        if (this.getRelation() != null) {
            joiner.add(String.format("%srelation%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getRelation()))));
        }
        if (this.getSubject() != null) {
            joiner.add(this.getSubject().toUrlQueryString((String)prefix + JSON_PROPERTY_SUBJECT + suffix));
        }
        return joiner.toString();
    }
}

