/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.4.2
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * DataDeleteResponse defines the structure of the response to a data delete request. It includes a snap_token representing the state of the database after the deletion.
 */
@JsonPropertyOrder({
  DataDeleteResponse.JSON_PROPERTY_SNAP_TOKEN
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class DataDeleteResponse {
  public static final String JSON_PROPERTY_SNAP_TOKEN = "snap_token";
  private String snapToken;

  public DataDeleteResponse() { 
  }

  public DataDeleteResponse snapToken(String snapToken) {
    this.snapToken = snapToken;
    return this;
  }

   /**
   * The snap token to avoid stale cache, see more details on [Snap Tokens](../../operations/snap-tokens)
   * @return snapToken
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SNAP_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSnapToken() {
    return snapToken;
  }


  @JsonProperty(JSON_PROPERTY_SNAP_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSnapToken(String snapToken) {
    this.snapToken = snapToken;
  }


  /**
   * Return true if this DataDeleteResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataDeleteResponse dataDeleteResponse = (DataDeleteResponse) o;
    return Objects.equals(this.snapToken, dataDeleteResponse.snapToken);
  }

  @Override
  public int hashCode() {
    return Objects.hash(snapToken);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataDeleteResponse {\n");
    sb.append("    snapToken: ").append(toIndentedString(snapToken)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `snap_token` to the URL query string
    if (getSnapToken() != null) {
      joiner.add(String.format("%ssnap_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSnapToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

