/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.4.2
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Child;
import co.permify.sdk.model.RewriteOperation;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * The Rewrite message represents a specific rewrite operation. This operation could be one of the following: union, intersection, or exclusion.
 */
@JsonPropertyOrder({
  Rewrite.JSON_PROPERTY_REWRITE_OPERATION,
  Rewrite.JSON_PROPERTY_CHILDREN
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class Rewrite {
  public static final String JSON_PROPERTY_REWRITE_OPERATION = "rewriteOperation";
  private RewriteOperation rewriteOperation;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private List<Child> children;

  public Rewrite() { 
  }

  public Rewrite rewriteOperation(RewriteOperation rewriteOperation) {
    this.rewriteOperation = rewriteOperation;
    return this;
  }

   /**
   * Get rewriteOperation
   * @return rewriteOperation
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REWRITE_OPERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RewriteOperation getRewriteOperation() {
    return rewriteOperation;
  }


  @JsonProperty(JSON_PROPERTY_REWRITE_OPERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRewriteOperation(RewriteOperation rewriteOperation) {
    this.rewriteOperation = rewriteOperation;
  }


  public Rewrite children(List<Child> children) {
    this.children = children;
    return this;
  }

  public Rewrite addChildrenItem(Child childrenItem) {
    if (this.children == null) {
      this.children = new ArrayList<>();
    }
    this.children.add(childrenItem);
    return this;
  }

   /**
   * A list of children that are operated upon by the rewrite operation.
   * @return children
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Child> getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildren(List<Child> children) {
    this.children = children;
  }


  /**
   * Return true if this Rewrite object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Rewrite rewrite = (Rewrite) o;
    return Objects.equals(this.rewriteOperation, rewrite.rewriteOperation) &&
        Objects.equals(this.children, rewrite.children);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rewriteOperation, children);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Rewrite {\n");
    sb.append("    rewriteOperation: ").append(toIndentedString(rewriteOperation)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `rewriteOperation` to the URL query string
    if (getRewriteOperation() != null) {
      joiner.add(String.format("%srewriteOperation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRewriteOperation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `children` to the URL query string
    if (getChildren() != null) {
      for (int i = 0; i < getChildren().size(); i++) {
        if (getChildren().get(i) != null) {
          joiner.add(getChildren().get(i).toUrlQueryString(String.format("%schildren%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }
}

