/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.4.2
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Tenant;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * TenantListResponse is the message returned from the request to list all tenants.
 */
@JsonPropertyOrder({
  TenantListResponse.JSON_PROPERTY_TENANTS,
  TenantListResponse.JSON_PROPERTY_CONTINUOUS_TOKEN
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class TenantListResponse {
  public static final String JSON_PROPERTY_TENANTS = "tenants";
  private List<Tenant> tenants;

  public static final String JSON_PROPERTY_CONTINUOUS_TOKEN = "continuous_token";
  private String continuousToken;

  public TenantListResponse() { 
  }

  public TenantListResponse tenants(List<Tenant> tenants) {
    this.tenants = tenants;
    return this;
  }

  public TenantListResponse addTenantsItem(Tenant tenantsItem) {
    if (this.tenants == null) {
      this.tenants = new ArrayList<>();
    }
    this.tenants.add(tenantsItem);
    return this;
  }

   /**
   * tenants is a list of tenants.
   * @return tenants
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Tenant> getTenants() {
    return tenants;
  }


  @JsonProperty(JSON_PROPERTY_TENANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenants(List<Tenant> tenants) {
    this.tenants = tenants;
  }


  public TenantListResponse continuousToken(String continuousToken) {
    this.continuousToken = continuousToken;
    return this;
  }

   /**
   * continuous_token is a string that can be used to paginate and retrieve the next set of results.
   * @return continuousToken
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTINUOUS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinuousToken() {
    return continuousToken;
  }


  @JsonProperty(JSON_PROPERTY_CONTINUOUS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinuousToken(String continuousToken) {
    this.continuousToken = continuousToken;
  }


  /**
   * Return true if this TenantListResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TenantListResponse tenantListResponse = (TenantListResponse) o;
    return Objects.equals(this.tenants, tenantListResponse.tenants) &&
        Objects.equals(this.continuousToken, tenantListResponse.continuousToken);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenants, continuousToken);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TenantListResponse {\n");
    sb.append("    tenants: ").append(toIndentedString(tenants)).append("\n");
    sb.append("    continuousToken: ").append(toIndentedString(continuousToken)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `tenants` to the URL query string
    if (getTenants() != null) {
      for (int i = 0; i < getTenants().size(); i++) {
        if (getTenants().get(i) != null) {
          joiner.add(getTenants().get(i).toUrlQueryString(String.format("%stenants%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `continuous_token` to the URL query string
    if (getContinuousToken() != null) {
      joiner.add(String.format("%scontinuous_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContinuousToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

