/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum AttributeType {
    BOOLEAN("ATTRIBUTE_TYPE_BOOLEAN"),
    BOOLEAN_ARRAY("ATTRIBUTE_TYPE_BOOLEAN_ARRAY"),
    STRING("ATTRIBUTE_TYPE_STRING"),
    STRING_ARRAY("ATTRIBUTE_TYPE_STRING_ARRAY"),
    INTEGER("ATTRIBUTE_TYPE_INTEGER"),
    INTEGER_ARRAY("ATTRIBUTE_TYPE_INTEGER_ARRAY"),
    DOUBLE("ATTRIBUTE_TYPE_DOUBLE"),
    DOUBLE_ARRAY("ATTRIBUTE_TYPE_DOUBLE_ARRAY");

    private String value;

    private AttributeType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static AttributeType fromValue(String value) {
        for (AttributeType b : AttributeType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

