/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.model.Attribute;
import co.permify.sdk.model.Tuple;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"tuples", "attributes", "data"})
public class Context {
    public static final String JSON_PROPERTY_TUPLES = "tuples";
    private List<Tuple> tuples;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private List<Attribute> attributes;
    public static final String JSON_PROPERTY_DATA = "data";
    private Object data;

    public Context tuples(List<Tuple> tuples) {
        this.tuples = tuples;
        return this;
    }

    public Context addTuplesItem(Tuple tuplesItem) {
        if (this.tuples == null) {
            this.tuples = new ArrayList<Tuple>();
        }
        this.tuples.add(tuplesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tuples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Tuple> getTuples() {
        return this.tuples;
    }

    @JsonProperty(value="tuples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTuples(List<Tuple> tuples) {
        this.tuples = tuples;
    }

    public Context attributes(List<Attribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public Context addAttributesItem(Attribute attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public Context data(Object data) {
        this.data = data;
        return this;
    }

    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setData(Object data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context context = (Context)o;
        return Objects.equals(this.tuples, context.tuples) && Objects.equals(this.attributes, context.attributes) && Objects.equals(this.data, context.data);
    }

    public int hashCode() {
        return Objects.hash(this.tuples, this.attributes, this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Context {\n");
        sb.append("    tuples: ").append(this.toIndentedString(this.tuples)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTuples() != null) {
            for (i = 0; i < this.getTuples().size(); ++i) {
                if (this.getTuples().get(i) == null) continue;
                joiner.add(this.getTuples().get(i).toUrlQueryString(String.format("%stuples%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getAttributes() != null) {
            for (i = 0; i < this.getAttributes().size(); ++i) {
                if (this.getAttributes().get(i) == null) continue;
                joiner.add(this.getAttributes().get(i).toUrlQueryString(String.format("%sattributes%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getData() != null) {
            joiner.add(String.format("%sdata%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getData()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

