/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.model.V1Operation;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "arguments", "operations"})
public class DataBundle {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ARGUMENTS = "arguments";
    private List<String> arguments;
    public static final String JSON_PROPERTY_OPERATIONS = "operations";
    private List<V1Operation> operations;

    public DataBundle name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public DataBundle arguments(List<String> arguments) {
        this.arguments = arguments;
        return this;
    }

    public DataBundle addArgumentsItem(String argumentsItem) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        this.arguments.add(argumentsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="arguments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getArguments() {
        return this.arguments;
    }

    @JsonProperty(value="arguments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public DataBundle operations(List<V1Operation> operations) {
        this.operations = operations;
        return this;
    }

    public DataBundle addOperationsItem(V1Operation operationsItem) {
        if (this.operations == null) {
            this.operations = new ArrayList<V1Operation>();
        }
        this.operations.add(operationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="operations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<V1Operation> getOperations() {
        return this.operations;
    }

    @JsonProperty(value="operations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperations(List<V1Operation> operations) {
        this.operations = operations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataBundle dataBundle = (DataBundle)o;
        return Objects.equals(this.name, dataBundle.name) && Objects.equals(this.arguments, dataBundle.arguments) && Objects.equals(this.operations, dataBundle.operations);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.arguments, this.operations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataBundle {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getArguments() != null) {
            for (i = 0; i < this.getArguments().size(); ++i) {
                joiner.add(String.format("%sarguments%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getArguments().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getOperations() != null) {
            for (i = 0; i < this.getOperations().size(); ++i) {
                if (this.getOperations().get(i) == null) continue;
                joiner.add(this.getOperations().get(i).toUrlQueryString(String.format("%soperations%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

