/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.model.Expr;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"target", "function", "args"})
public class ExprCall {
    public static final String JSON_PROPERTY_TARGET = "target";
    private Expr target;
    public static final String JSON_PROPERTY_FUNCTION = "function";
    private String function;
    public static final String JSON_PROPERTY_ARGS = "args";
    private List<Expr> args;

    public ExprCall target(Expr target) {
        this.target = target;
        return this;
    }

    @Nullable
    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Expr getTarget() {
        return this.target;
    }

    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTarget(Expr target) {
        this.target = target;
    }

    public ExprCall function(String function) {
        this.function = function;
        return this;
    }

    @Nullable
    @JsonProperty(value="function")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFunction() {
        return this.function;
    }

    @JsonProperty(value="function")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFunction(String function) {
        this.function = function;
    }

    public ExprCall args(List<Expr> args) {
        this.args = args;
        return this;
    }

    public ExprCall addArgsItem(Expr argsItem) {
        if (this.args == null) {
            this.args = new ArrayList<Expr>();
        }
        this.args.add(argsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="args")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Expr> getArgs() {
        return this.args;
    }

    @JsonProperty(value="args")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArgs(List<Expr> args) {
        this.args = args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExprCall exprCall = (ExprCall)o;
        return Objects.equals(this.target, exprCall.target) && Objects.equals(this.function, exprCall.function) && Objects.equals(this.args, exprCall.args);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.function, this.args);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExprCall {\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    function: ").append(this.toIndentedString(this.function)).append("\n");
        sb.append("    args: ").append(this.toIndentedString(this.args)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTarget() != null) {
            joiner.add(this.getTarget().toUrlQueryString((String)prefix + JSON_PROPERTY_TARGET + suffix));
        }
        if (this.getFunction() != null) {
            joiner.add(String.format("%sfunction%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFunction()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getArgs() != null) {
            for (int i = 0; i < this.getArgs().size(); ++i) {
                if (this.getArgs().get(i) == null) continue;
                joiner.add(this.getArgs().get(i).toUrlQueryString(String.format("%sargs%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

