/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.model.Argument;
import co.permify.sdk.model.Context;
import co.permify.sdk.model.Entity;
import co.permify.sdk.model.PermissionLookupSubjectRequestMetadata;
import co.permify.sdk.model.RelationReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"metadata", "entity", "permission", "subject_reference", "context", "arguments", "page_size", "continuous_token"})
public class LookupSubjectBody {
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private PermissionLookupSubjectRequestMetadata metadata;
    public static final String JSON_PROPERTY_ENTITY = "entity";
    private Entity entity;
    public static final String JSON_PROPERTY_PERMISSION = "permission";
    private String permission;
    public static final String JSON_PROPERTY_SUBJECT_REFERENCE = "subject_reference";
    private RelationReference subjectReference;
    public static final String JSON_PROPERTY_CONTEXT = "context";
    private Context context;
    public static final String JSON_PROPERTY_ARGUMENTS = "arguments";
    private List<Argument> arguments;
    public static final String JSON_PROPERTY_PAGE_SIZE = "page_size";
    private Long pageSize;
    public static final String JSON_PROPERTY_CONTINUOUS_TOKEN = "continuous_token";
    private String continuousToken;

    public LookupSubjectBody metadata(PermissionLookupSubjectRequestMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PermissionLookupSubjectRequestMetadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(PermissionLookupSubjectRequestMetadata metadata) {
        this.metadata = metadata;
    }

    public LookupSubjectBody entity(Entity entity) {
        this.entity = entity;
        return this;
    }

    @Nullable
    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Entity getEntity() {
        return this.entity;
    }

    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public LookupSubjectBody permission(String permission) {
        this.permission = permission;
        return this;
    }

    @Nullable
    @JsonProperty(value="permission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPermission() {
        return this.permission;
    }

    @JsonProperty(value="permission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPermission(String permission) {
        this.permission = permission;
    }

    public LookupSubjectBody subjectReference(RelationReference subjectReference) {
        this.subjectReference = subjectReference;
        return this;
    }

    @Nullable
    @JsonProperty(value="subject_reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RelationReference getSubjectReference() {
        return this.subjectReference;
    }

    @JsonProperty(value="subject_reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubjectReference(RelationReference subjectReference) {
        this.subjectReference = subjectReference;
    }

    public LookupSubjectBody context(Context context) {
        this.context = context;
        return this;
    }

    @Nullable
    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Context getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContext(Context context) {
        this.context = context;
    }

    public LookupSubjectBody arguments(List<Argument> arguments) {
        this.arguments = arguments;
        return this;
    }

    public LookupSubjectBody addArgumentsItem(Argument argumentsItem) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<Argument>();
        }
        this.arguments.add(argumentsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="arguments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @JsonProperty(value="arguments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArguments(List<Argument> arguments) {
        this.arguments = arguments;
    }

    public LookupSubjectBody pageSize(Long pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="page_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="page_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageSize(Long pageSize) {
        this.pageSize = pageSize;
    }

    public LookupSubjectBody continuousToken(String continuousToken) {
        this.continuousToken = continuousToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="continuous_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContinuousToken() {
        return this.continuousToken;
    }

    @JsonProperty(value="continuous_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContinuousToken(String continuousToken) {
        this.continuousToken = continuousToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupSubjectBody lookupSubjectBody = (LookupSubjectBody)o;
        return Objects.equals(this.metadata, lookupSubjectBody.metadata) && Objects.equals(this.entity, lookupSubjectBody.entity) && Objects.equals(this.permission, lookupSubjectBody.permission) && Objects.equals(this.subjectReference, lookupSubjectBody.subjectReference) && Objects.equals(this.context, lookupSubjectBody.context) && Objects.equals(this.arguments, lookupSubjectBody.arguments) && Objects.equals(this.pageSize, lookupSubjectBody.pageSize) && Objects.equals(this.continuousToken, lookupSubjectBody.continuousToken);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.entity, this.permission, this.subjectReference, this.context, this.arguments, this.pageSize, this.continuousToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LookupSubjectBody {\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    permission: ").append(this.toIndentedString(this.permission)).append("\n");
        sb.append("    subjectReference: ").append(this.toIndentedString(this.subjectReference)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    continuousToken: ").append(this.toIndentedString(this.continuousToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getMetadata() != null) {
            joiner.add(this.getMetadata().toUrlQueryString((String)prefix + JSON_PROPERTY_METADATA + suffix));
        }
        if (this.getEntity() != null) {
            joiner.add(this.getEntity().toUrlQueryString((String)prefix + JSON_PROPERTY_ENTITY + suffix));
        }
        if (this.getPermission() != null) {
            joiner.add(String.format("%spermission%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPermission()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSubjectReference() != null) {
            joiner.add(this.getSubjectReference().toUrlQueryString((String)prefix + JSON_PROPERTY_SUBJECT_REFERENCE + suffix));
        }
        if (this.getContext() != null) {
            joiner.add(this.getContext().toUrlQueryString((String)prefix + JSON_PROPERTY_CONTEXT + suffix));
        }
        if (this.getArguments() != null) {
            for (int i = 0; i < this.getArguments().size(); ++i) {
                if (this.getArguments().get(i) == null) continue;
                joiner.add(this.getArguments().get(i).toUrlQueryString(String.format("%sarguments%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getPageSize() != null) {
            joiner.add(String.format("%spage_size%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPageSize()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getContinuousToken() != null) {
            joiner.add(String.format("%scontinuous_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getContinuousToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

