/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.model.Tenant;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"tenants", "continuous_token"})
public class TenantListResponse {
    public static final String JSON_PROPERTY_TENANTS = "tenants";
    private List<Tenant> tenants;
    public static final String JSON_PROPERTY_CONTINUOUS_TOKEN = "continuous_token";
    private String continuousToken;

    public TenantListResponse tenants(List<Tenant> tenants) {
        this.tenants = tenants;
        return this;
    }

    public TenantListResponse addTenantsItem(Tenant tenantsItem) {
        if (this.tenants == null) {
            this.tenants = new ArrayList<Tenant>();
        }
        this.tenants.add(tenantsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tenants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Tenant> getTenants() {
        return this.tenants;
    }

    @JsonProperty(value="tenants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenants(List<Tenant> tenants) {
        this.tenants = tenants;
    }

    public TenantListResponse continuousToken(String continuousToken) {
        this.continuousToken = continuousToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="continuous_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContinuousToken() {
        return this.continuousToken;
    }

    @JsonProperty(value="continuous_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContinuousToken(String continuousToken) {
        this.continuousToken = continuousToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantListResponse tenantListResponse = (TenantListResponse)o;
        return Objects.equals(this.tenants, tenantListResponse.tenants) && Objects.equals(this.continuousToken, tenantListResponse.continuousToken);
    }

    public int hashCode() {
        return Objects.hash(this.tenants, this.continuousToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TenantListResponse {\n");
        sb.append("    tenants: ").append(this.toIndentedString(this.tenants)).append("\n");
        sb.append("    continuousToken: ").append(this.toIndentedString(this.continuousToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTenants() != null) {
            for (int i = 0; i < this.getTenants().size(); ++i) {
                if (this.getTenants().get(i) == null) continue;
                joiner.add(this.getTenants().get(i).toUrlQueryString(String.format("%stenants%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getContinuousToken() != null) {
            joiner.add(String.format("%scontinuous_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getContinuousToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

