/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.4.3
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.AttributeFilter;
import co.permify.sdk.model.TupleFilter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * DataDeleteRequest defines the structure of a request to delete data. It includes the tenant_id and filters for selecting tuples and attributes to be deleted.
 */
@JsonPropertyOrder({
  DataDeleteBody.JSON_PROPERTY_TUPLE_FILTER,
  DataDeleteBody.JSON_PROPERTY_ATTRIBUTE_FILTER
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class DataDeleteBody {
  public static final String JSON_PROPERTY_TUPLE_FILTER = "tuple_filter";
  private TupleFilter tupleFilter;

  public static final String JSON_PROPERTY_ATTRIBUTE_FILTER = "attribute_filter";
  private AttributeFilter attributeFilter;

  public DataDeleteBody() { 
  }

  public DataDeleteBody tupleFilter(TupleFilter tupleFilter) {
    this.tupleFilter = tupleFilter;
    return this;
  }

   /**
   * Get tupleFilter
   * @return tupleFilter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TUPLE_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TupleFilter getTupleFilter() {
    return tupleFilter;
  }


  @JsonProperty(JSON_PROPERTY_TUPLE_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTupleFilter(TupleFilter tupleFilter) {
    this.tupleFilter = tupleFilter;
  }


  public DataDeleteBody attributeFilter(AttributeFilter attributeFilter) {
    this.attributeFilter = attributeFilter;
    return this;
  }

   /**
   * Get attributeFilter
   * @return attributeFilter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTE_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AttributeFilter getAttributeFilter() {
    return attributeFilter;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTE_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributeFilter(AttributeFilter attributeFilter) {
    this.attributeFilter = attributeFilter;
  }


  /**
   * Return true if this Data.DeleteBody object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataDeleteBody dataDeleteBody = (DataDeleteBody) o;
    return Objects.equals(this.tupleFilter, dataDeleteBody.tupleFilter) &&
        Objects.equals(this.attributeFilter, dataDeleteBody.attributeFilter);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tupleFilter, attributeFilter);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataDeleteBody {\n");
    sb.append("    tupleFilter: ").append(toIndentedString(tupleFilter)).append("\n");
    sb.append("    attributeFilter: ").append(toIndentedString(attributeFilter)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `tuple_filter` to the URL query string
    if (getTupleFilter() != null) {
      joiner.add(getTupleFilter().toUrlQueryString(prefix + "tuple_filter" + suffix));
    }

    // add `attribute_filter` to the URL query string
    if (getAttributeFilter() != null) {
      joiner.add(getAttributeFilter().toUrlQueryString(prefix + "attribute_filter" + suffix));
    }

    return joiner.toString();
  }
}

