/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.4.3
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Expr;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * A call expression, including calls to predefined functions and operators.  For example, &#x60;value &#x3D;&#x3D; 10&#x60;, &#x60;size(map_value)&#x60;.
 */
@JsonPropertyOrder({
  ExprCall.JSON_PROPERTY_TARGET,
  ExprCall.JSON_PROPERTY_FUNCTION,
  ExprCall.JSON_PROPERTY_ARGS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ExprCall {
  public static final String JSON_PROPERTY_TARGET = "target";
  private Expr target;

  public static final String JSON_PROPERTY_FUNCTION = "function";
  private String function;

  public static final String JSON_PROPERTY_ARGS = "args";
  private List<Expr> args;

  public ExprCall() { 
  }

  public ExprCall target(Expr target) {
    this.target = target;
    return this;
  }

   /**
   * Get target
   * @return target
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TARGET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Expr getTarget() {
    return target;
  }


  @JsonProperty(JSON_PROPERTY_TARGET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTarget(Expr target) {
    this.target = target;
  }


  public ExprCall function(String function) {
    this.function = function;
    return this;
  }

   /**
   * Required. The name of the function or method being called.
   * @return function
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FUNCTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFunction() {
    return function;
  }


  @JsonProperty(JSON_PROPERTY_FUNCTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFunction(String function) {
    this.function = function;
  }


  public ExprCall args(List<Expr> args) {
    this.args = args;
    return this;
  }

  public ExprCall addArgsItem(Expr argsItem) {
    if (this.args == null) {
      this.args = new ArrayList<>();
    }
    this.args.add(argsItem);
    return this;
  }

   /**
   * The arguments.
   * @return args
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ARGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Expr> getArgs() {
    return args;
  }


  @JsonProperty(JSON_PROPERTY_ARGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArgs(List<Expr> args) {
    this.args = args;
  }


  /**
   * Return true if this Expr.Call object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExprCall exprCall = (ExprCall) o;
    return Objects.equals(this.target, exprCall.target) &&
        Objects.equals(this.function, exprCall.function) &&
        Objects.equals(this.args, exprCall.args);
  }

  @Override
  public int hashCode() {
    return Objects.hash(target, function, args);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExprCall {\n");
    sb.append("    target: ").append(toIndentedString(target)).append("\n");
    sb.append("    function: ").append(toIndentedString(function)).append("\n");
    sb.append("    args: ").append(toIndentedString(args)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `target` to the URL query string
    if (getTarget() != null) {
      joiner.add(getTarget().toUrlQueryString(prefix + "target" + suffix));
    }

    // add `function` to the URL query string
    if (getFunction() != null) {
      joiner.add(String.format("%sfunction%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFunction()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `args` to the URL query string
    if (getArgs() != null) {
      for (int i = 0; i < getArgs().size(); i++) {
        if (getArgs().get(i) != null) {
          joiner.add(getArgs().get(i).toUrlQueryString(String.format("%sargs%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }
}

