/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.4.3
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Argument;
import co.permify.sdk.model.Context;
import co.permify.sdk.model.Entity;
import co.permify.sdk.model.PermissionLookupSubjectRequestMetadata;
import co.permify.sdk.model.RelationReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * PermissionLookupSubjectRequest is the request message for the LookupSubject method in the Permission service.
 */
@JsonPropertyOrder({
  LookupSubjectBody.JSON_PROPERTY_METADATA,
  LookupSubjectBody.JSON_PROPERTY_ENTITY,
  LookupSubjectBody.JSON_PROPERTY_PERMISSION,
  LookupSubjectBody.JSON_PROPERTY_SUBJECT_REFERENCE,
  LookupSubjectBody.JSON_PROPERTY_CONTEXT,
  LookupSubjectBody.JSON_PROPERTY_ARGUMENTS,
  LookupSubjectBody.JSON_PROPERTY_PAGE_SIZE,
  LookupSubjectBody.JSON_PROPERTY_CONTINUOUS_TOKEN
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class LookupSubjectBody {
  public static final String JSON_PROPERTY_METADATA = "metadata";
  private PermissionLookupSubjectRequestMetadata metadata;

  public static final String JSON_PROPERTY_ENTITY = "entity";
  private Entity entity;

  public static final String JSON_PROPERTY_PERMISSION = "permission";
  private String permission;

  public static final String JSON_PROPERTY_SUBJECT_REFERENCE = "subject_reference";
  private RelationReference subjectReference;

  public static final String JSON_PROPERTY_CONTEXT = "context";
  private Context context;

  public static final String JSON_PROPERTY_ARGUMENTS = "arguments";
  private List<Argument> arguments;

  public static final String JSON_PROPERTY_PAGE_SIZE = "page_size";
  private Long pageSize;

  public static final String JSON_PROPERTY_CONTINUOUS_TOKEN = "continuous_token";
  private String continuousToken;

  public LookupSubjectBody() { 
  }

  public LookupSubjectBody metadata(PermissionLookupSubjectRequestMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PermissionLookupSubjectRequestMetadata getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(PermissionLookupSubjectRequestMetadata metadata) {
    this.metadata = metadata;
  }


  public LookupSubjectBody entity(Entity entity) {
    this.entity = entity;
    return this;
  }

   /**
   * Get entity
   * @return entity
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ENTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Entity getEntity() {
    return entity;
  }


  @JsonProperty(JSON_PROPERTY_ENTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEntity(Entity entity) {
    this.entity = entity;
  }


  public LookupSubjectBody permission(String permission) {
    this.permission = permission;
    return this;
  }

   /**
   * Permission to be checked, can be a permission or relation. Required, and must match the pattern \&quot;^([a-zA-Z][a-zA-Z0-9_]{1,62}[a-zA-Z0-9])$\&quot;, max 64 bytes.
   * @return permission
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PERMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPermission() {
    return permission;
  }


  @JsonProperty(JSON_PROPERTY_PERMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPermission(String permission) {
    this.permission = permission;
  }


  public LookupSubjectBody subjectReference(RelationReference subjectReference) {
    this.subjectReference = subjectReference;
    return this;
  }

   /**
   * Get subjectReference
   * @return subjectReference
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RelationReference getSubjectReference() {
    return subjectReference;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubjectReference(RelationReference subjectReference) {
    this.subjectReference = subjectReference;
  }


  public LookupSubjectBody context(Context context) {
    this.context = context;
    return this;
  }

   /**
   * Get context
   * @return context
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Context getContext() {
    return context;
  }


  @JsonProperty(JSON_PROPERTY_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContext(Context context) {
    this.context = context;
  }


  public LookupSubjectBody arguments(List<Argument> arguments) {
    this.arguments = arguments;
    return this;
  }

  public LookupSubjectBody addArgumentsItem(Argument argumentsItem) {
    if (this.arguments == null) {
      this.arguments = new ArrayList<>();
    }
    this.arguments.add(argumentsItem);
    return this;
  }

   /**
   * Additional arguments associated with this request.
   * @return arguments
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ARGUMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Argument> getArguments() {
    return arguments;
  }


  @JsonProperty(JSON_PROPERTY_ARGUMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArguments(List<Argument> arguments) {
    this.arguments = arguments;
  }


  public LookupSubjectBody pageSize(Long pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * page_size is the number of subjects to be returned in the response. The value should be between 1 and 100.
   * @return pageSize
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPageSize() {
    return pageSize;
  }


  @JsonProperty(JSON_PROPERTY_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }


  public LookupSubjectBody continuousToken(String continuousToken) {
    this.continuousToken = continuousToken;
    return this;
  }

   /**
   * continuous_token is an optional parameter used for pagination. It should be the value received in the previous response.
   * @return continuousToken
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTINUOUS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinuousToken() {
    return continuousToken;
  }


  @JsonProperty(JSON_PROPERTY_CONTINUOUS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinuousToken(String continuousToken) {
    this.continuousToken = continuousToken;
  }


  /**
   * Return true if this LookupSubjectBody object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LookupSubjectBody lookupSubjectBody = (LookupSubjectBody) o;
    return Objects.equals(this.metadata, lookupSubjectBody.metadata) &&
        Objects.equals(this.entity, lookupSubjectBody.entity) &&
        Objects.equals(this.permission, lookupSubjectBody.permission) &&
        Objects.equals(this.subjectReference, lookupSubjectBody.subjectReference) &&
        Objects.equals(this.context, lookupSubjectBody.context) &&
        Objects.equals(this.arguments, lookupSubjectBody.arguments) &&
        Objects.equals(this.pageSize, lookupSubjectBody.pageSize) &&
        Objects.equals(this.continuousToken, lookupSubjectBody.continuousToken);
  }

  @Override
  public int hashCode() {
    return Objects.hash(metadata, entity, permission, subjectReference, context, arguments, pageSize, continuousToken);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LookupSubjectBody {\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    entity: ").append(toIndentedString(entity)).append("\n");
    sb.append("    permission: ").append(toIndentedString(permission)).append("\n");
    sb.append("    subjectReference: ").append(toIndentedString(subjectReference)).append("\n");
    sb.append("    context: ").append(toIndentedString(context)).append("\n");
    sb.append("    arguments: ").append(toIndentedString(arguments)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    continuousToken: ").append(toIndentedString(continuousToken)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `metadata` to the URL query string
    if (getMetadata() != null) {
      joiner.add(getMetadata().toUrlQueryString(prefix + "metadata" + suffix));
    }

    // add `entity` to the URL query string
    if (getEntity() != null) {
      joiner.add(getEntity().toUrlQueryString(prefix + "entity" + suffix));
    }

    // add `permission` to the URL query string
    if (getPermission() != null) {
      joiner.add(String.format("%spermission%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPermission()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `subject_reference` to the URL query string
    if (getSubjectReference() != null) {
      joiner.add(getSubjectReference().toUrlQueryString(prefix + "subject_reference" + suffix));
    }

    // add `context` to the URL query string
    if (getContext() != null) {
      joiner.add(getContext().toUrlQueryString(prefix + "context" + suffix));
    }

    // add `arguments` to the URL query string
    if (getArguments() != null) {
      for (int i = 0; i < getArguments().size(); i++) {
        if (getArguments().get(i) != null) {
          joiner.add(getArguments().get(i).toUrlQueryString(String.format("%sarguments%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `page_size` to the URL query string
    if (getPageSize() != null) {
      joiner.add(String.format("%spage_size%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPageSize()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `continuous_token` to the URL query string
    if (getContinuousToken() != null) {
      joiner.add(String.format("%scontinuous_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContinuousToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

