/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.4.3
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Tuple;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * RelationshipReadResponse defines the structure of the response after reading relationships. It includes the tuples representing the relationships and a continuous token for handling result pagination.
 */
@JsonPropertyOrder({
  RelationshipReadResponse.JSON_PROPERTY_TUPLES,
  RelationshipReadResponse.JSON_PROPERTY_CONTINUOUS_TOKEN
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class RelationshipReadResponse {
  public static final String JSON_PROPERTY_TUPLES = "tuples";
  private List<Tuple> tuples;

  public static final String JSON_PROPERTY_CONTINUOUS_TOKEN = "continuous_token";
  private String continuousToken;

  public RelationshipReadResponse() { 
  }

  public RelationshipReadResponse tuples(List<Tuple> tuples) {
    this.tuples = tuples;
    return this;
  }

  public RelationshipReadResponse addTuplesItem(Tuple tuplesItem) {
    if (this.tuples == null) {
      this.tuples = new ArrayList<>();
    }
    this.tuples.add(tuplesItem);
    return this;
  }

   /**
   * tuples is a list of the relationships retrieved in the read operation, represented as entity-relation-entity triples.
   * @return tuples
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TUPLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Tuple> getTuples() {
    return tuples;
  }


  @JsonProperty(JSON_PROPERTY_TUPLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTuples(List<Tuple> tuples) {
    this.tuples = tuples;
  }


  public RelationshipReadResponse continuousToken(String continuousToken) {
    this.continuousToken = continuousToken;
    return this;
  }

   /**
   * continuous_token is used in the case of paginated reads to retrieve the next page of results.
   * @return continuousToken
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTINUOUS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinuousToken() {
    return continuousToken;
  }


  @JsonProperty(JSON_PROPERTY_CONTINUOUS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinuousToken(String continuousToken) {
    this.continuousToken = continuousToken;
  }


  /**
   * Return true if this RelationshipReadResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RelationshipReadResponse relationshipReadResponse = (RelationshipReadResponse) o;
    return Objects.equals(this.tuples, relationshipReadResponse.tuples) &&
        Objects.equals(this.continuousToken, relationshipReadResponse.continuousToken);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tuples, continuousToken);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RelationshipReadResponse {\n");
    sb.append("    tuples: ").append(toIndentedString(tuples)).append("\n");
    sb.append("    continuousToken: ").append(toIndentedString(continuousToken)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `tuples` to the URL query string
    if (getTuples() != null) {
      for (int i = 0; i < getTuples().size(); i++) {
        if (getTuples().get(i) != null) {
          joiner.add(getTuples().get(i).toUrlQueryString(String.format("%stuples%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `continuous_token` to the URL query string
    if (getContinuousToken() != null) {
      joiner.add(String.format("%scontinuous_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContinuousToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

