/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.4.3
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.EntityDefinition;
import co.permify.sdk.model.RuleDefinition;
import co.permify.sdk.model.SchemaDefinitionReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * The SchemaDefinition message provides definitions for entities and rules, and includes references to clarify whether a name refers to an entity or a rule.
 */
@JsonPropertyOrder({
  SchemaDefinition.JSON_PROPERTY_ENTITY_DEFINITIONS,
  SchemaDefinition.JSON_PROPERTY_RULE_DEFINITIONS,
  SchemaDefinition.JSON_PROPERTY_REFERENCES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class SchemaDefinition {
  public static final String JSON_PROPERTY_ENTITY_DEFINITIONS = "entityDefinitions";
  private Map<String, EntityDefinition> entityDefinitions = new HashMap<>();

  public static final String JSON_PROPERTY_RULE_DEFINITIONS = "ruleDefinitions";
  private Map<String, RuleDefinition> ruleDefinitions = new HashMap<>();

  public static final String JSON_PROPERTY_REFERENCES = "references";
  private Map<String, SchemaDefinitionReference> references = new HashMap<>();

  public SchemaDefinition() { 
  }

  public SchemaDefinition entityDefinitions(Map<String, EntityDefinition> entityDefinitions) {
    this.entityDefinitions = entityDefinitions;
    return this;
  }

  public SchemaDefinition putEntityDefinitionsItem(String key, EntityDefinition entityDefinitionsItem) {
    if (this.entityDefinitions == null) {
      this.entityDefinitions = new HashMap<>();
    }
    this.entityDefinitions.put(key, entityDefinitionsItem);
    return this;
  }

   /**
   * Map of entity definitions. The key is the entity name, and the value is the corresponding EntityDefinition.
   * @return entityDefinitions
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ENTITY_DEFINITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, EntityDefinition> getEntityDefinitions() {
    return entityDefinitions;
  }


  @JsonProperty(JSON_PROPERTY_ENTITY_DEFINITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEntityDefinitions(Map<String, EntityDefinition> entityDefinitions) {
    this.entityDefinitions = entityDefinitions;
  }


  public SchemaDefinition ruleDefinitions(Map<String, RuleDefinition> ruleDefinitions) {
    this.ruleDefinitions = ruleDefinitions;
    return this;
  }

  public SchemaDefinition putRuleDefinitionsItem(String key, RuleDefinition ruleDefinitionsItem) {
    if (this.ruleDefinitions == null) {
      this.ruleDefinitions = new HashMap<>();
    }
    this.ruleDefinitions.put(key, ruleDefinitionsItem);
    return this;
  }

   /**
   * Map of rule definitions. The key is the rule name, and the value is the corresponding RuleDefinition.
   * @return ruleDefinitions
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RULE_DEFINITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, RuleDefinition> getRuleDefinitions() {
    return ruleDefinitions;
  }


  @JsonProperty(JSON_PROPERTY_RULE_DEFINITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRuleDefinitions(Map<String, RuleDefinition> ruleDefinitions) {
    this.ruleDefinitions = ruleDefinitions;
  }


  public SchemaDefinition references(Map<String, SchemaDefinitionReference> references) {
    this.references = references;
    return this;
  }

  public SchemaDefinition putReferencesItem(String key, SchemaDefinitionReference referencesItem) {
    if (this.references == null) {
      this.references = new HashMap<>();
    }
    this.references.put(key, referencesItem);
    return this;
  }

   /**
   * Map of references to signify whether a string refers to an entity or a rule.
   * @return references
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REFERENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, SchemaDefinitionReference> getReferences() {
    return references;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReferences(Map<String, SchemaDefinitionReference> references) {
    this.references = references;
  }


  /**
   * Return true if this SchemaDefinition object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SchemaDefinition schemaDefinition = (SchemaDefinition) o;
    return Objects.equals(this.entityDefinitions, schemaDefinition.entityDefinitions) &&
        Objects.equals(this.ruleDefinitions, schemaDefinition.ruleDefinitions) &&
        Objects.equals(this.references, schemaDefinition.references);
  }

  @Override
  public int hashCode() {
    return Objects.hash(entityDefinitions, ruleDefinitions, references);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SchemaDefinition {\n");
    sb.append("    entityDefinitions: ").append(toIndentedString(entityDefinitions)).append("\n");
    sb.append("    ruleDefinitions: ").append(toIndentedString(ruleDefinitions)).append("\n");
    sb.append("    references: ").append(toIndentedString(references)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `entityDefinitions` to the URL query string
    if (getEntityDefinitions() != null) {
      for (String _key : getEntityDefinitions().keySet()) {
        if (getEntityDefinitions().get(_key) != null) {
          joiner.add(getEntityDefinitions().get(_key).toUrlQueryString(String.format("%sentityDefinitions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `ruleDefinitions` to the URL query string
    if (getRuleDefinitions() != null) {
      for (String _key : getRuleDefinitions().keySet()) {
        if (getRuleDefinitions().get(_key) != null) {
          joiner.add(getRuleDefinitions().get(_key).toUrlQueryString(String.format("%sruleDefinitions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `references` to the URL query string
    if (getReferences() != null) {
      for (String _key : getReferences().keySet()) {
        joiner.add(String.format("%sreferences%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
            getReferences().get(_key), URLEncoder.encode(String.valueOf(getReferences().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    return joiner.toString();
  }
}

