/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.4.3
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.SchemaList;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * SchemaListResponse
 */
@JsonPropertyOrder({
  SchemaListResponse.JSON_PROPERTY_HEAD,
  SchemaListResponse.JSON_PROPERTY_SCHEMAS,
  SchemaListResponse.JSON_PROPERTY_CONTINUOUS_TOKEN
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class SchemaListResponse {
  public static final String JSON_PROPERTY_HEAD = "head";
  private String head;

  public static final String JSON_PROPERTY_SCHEMAS = "schemas";
  private List<SchemaList> schemas;

  public static final String JSON_PROPERTY_CONTINUOUS_TOKEN = "continuous_token";
  private String continuousToken;

  public SchemaListResponse() { 
  }

  public SchemaListResponse head(String head) {
    this.head = head;
    return this;
  }

   /**
   * Get head
   * @return head
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HEAD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHead() {
    return head;
  }


  @JsonProperty(JSON_PROPERTY_HEAD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHead(String head) {
    this.head = head;
  }


  public SchemaListResponse schemas(List<SchemaList> schemas) {
    this.schemas = schemas;
    return this;
  }

  public SchemaListResponse addSchemasItem(SchemaList schemasItem) {
    if (this.schemas == null) {
      this.schemas = new ArrayList<>();
    }
    this.schemas.add(schemasItem);
    return this;
  }

   /**
   * Get schemas
   * @return schemas
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SCHEMAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SchemaList> getSchemas() {
    return schemas;
  }


  @JsonProperty(JSON_PROPERTY_SCHEMAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSchemas(List<SchemaList> schemas) {
    this.schemas = schemas;
  }


  public SchemaListResponse continuousToken(String continuousToken) {
    this.continuousToken = continuousToken;
    return this;
  }

   /**
   * continuous_token is a string that can be used to paginate and retrieve the next set of results.
   * @return continuousToken
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTINUOUS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinuousToken() {
    return continuousToken;
  }


  @JsonProperty(JSON_PROPERTY_CONTINUOUS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinuousToken(String continuousToken) {
    this.continuousToken = continuousToken;
  }


  /**
   * Return true if this SchemaListResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SchemaListResponse schemaListResponse = (SchemaListResponse) o;
    return Objects.equals(this.head, schemaListResponse.head) &&
        Objects.equals(this.schemas, schemaListResponse.schemas) &&
        Objects.equals(this.continuousToken, schemaListResponse.continuousToken);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, schemas, continuousToken);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SchemaListResponse {\n");
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    schemas: ").append(toIndentedString(schemas)).append("\n");
    sb.append("    continuousToken: ").append(toIndentedString(continuousToken)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `head` to the URL query string
    if (getHead() != null) {
      joiner.add(String.format("%shead%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHead()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `schemas` to the URL query string
    if (getSchemas() != null) {
      for (int i = 0; i < getSchemas().size(); i++) {
        if (getSchemas().get(i) != null) {
          joiner.add(getSchemas().get(i).toUrlQueryString(String.format("%sschemas%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `continuous_token` to the URL query string
    if (getContinuousToken() != null) {
      joiner.add(String.format("%scontinuous_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContinuousToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

