/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.model.RelationReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "relationReferences"})
public class RelationDefinition {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_RELATION_REFERENCES = "relationReferences";
    private List<RelationReference> relationReferences;

    public RelationDefinition name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public RelationDefinition relationReferences(List<RelationReference> relationReferences) {
        this.relationReferences = relationReferences;
        return this;
    }

    public RelationDefinition addRelationReferencesItem(RelationReference relationReferencesItem) {
        if (this.relationReferences == null) {
            this.relationReferences = new ArrayList<RelationReference>();
        }
        this.relationReferences.add(relationReferencesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="relationReferences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RelationReference> getRelationReferences() {
        return this.relationReferences;
    }

    @JsonProperty(value="relationReferences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelationReferences(List<RelationReference> relationReferences) {
        this.relationReferences = relationReferences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationDefinition relationDefinition = (RelationDefinition)o;
        return Objects.equals(this.name, relationDefinition.name) && Objects.equals(this.relationReferences, relationDefinition.relationReferences);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.relationReferences);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelationDefinition {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    relationReferences: ").append(this.toIndentedString(this.relationReferences)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRelationReferences() != null) {
            for (int i = 0; i < this.getRelationReferences().size(); ++i) {
                if (this.getRelationReferences().get(i) == null) continue;
                joiner.add(this.getRelationReferences().get(i).toUrlQueryString(String.format("%srelationReferences%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

