/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.4.4
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Comprehension;
import co.permify.sdk.model.Constant;
import co.permify.sdk.model.CreateList;
import co.permify.sdk.model.CreateStruct;
import co.permify.sdk.model.ExprCall;
import co.permify.sdk.model.Ident;
import co.permify.sdk.model.Select;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * An abstract representation of a common expression.  Expressions are abstractly represented as a collection of identifiers, select statements, function calls, literals, and comprehensions. All operators with the exception of the &#39;.&#39; operator are modelled as function calls. This makes it easy to represent new operators into the existing AST.  All references within expressions must resolve to a [Decl][google.api.expr.v1alpha1.Decl] provided at type-check for an expression to be valid. A reference may either be a bare identifier &#x60;name&#x60; or a qualified identifier &#x60;google.api.name&#x60;. References may either refer to a value or a function declaration.  For example, the expression &#x60;google.api.name.startsWith(&#39;expr&#39;)&#x60; references the declaration &#x60;google.api.name&#x60; within a [Expr.Select][google.api.expr.v1alpha1.Expr.Select] expression, and the function declaration &#x60;startsWith&#x60;.
 */
@JsonPropertyOrder({
  Expr.JSON_PROPERTY_ID,
  Expr.JSON_PROPERTY_CONST_EXPR,
  Expr.JSON_PROPERTY_IDENT_EXPR,
  Expr.JSON_PROPERTY_SELECT_EXPR,
  Expr.JSON_PROPERTY_CALL_EXPR,
  Expr.JSON_PROPERTY_LIST_EXPR,
  Expr.JSON_PROPERTY_STRUCT_EXPR,
  Expr.JSON_PROPERTY_COMPREHENSION_EXPR
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class Expr {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_CONST_EXPR = "constExpr";
  private Constant constExpr;

  public static final String JSON_PROPERTY_IDENT_EXPR = "identExpr";
  private Ident identExpr;

  public static final String JSON_PROPERTY_SELECT_EXPR = "selectExpr";
  private Select selectExpr;

  public static final String JSON_PROPERTY_CALL_EXPR = "callExpr";
  private ExprCall callExpr;

  public static final String JSON_PROPERTY_LIST_EXPR = "listExpr";
  private CreateList listExpr;

  public static final String JSON_PROPERTY_STRUCT_EXPR = "structExpr";
  private CreateStruct structExpr;

  public static final String JSON_PROPERTY_COMPREHENSION_EXPR = "comprehensionExpr";
  private Comprehension comprehensionExpr;

  public Expr() { 
  }

  public Expr id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Required. An id assigned to this node by the parser which is unique in a given expression tree. This is used to associate type information and other attributes to a node in the parse tree.
   * @return id
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Expr constExpr(Constant constExpr) {
    this.constExpr = constExpr;
    return this;
  }

   /**
   * Get constExpr
   * @return constExpr
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONST_EXPR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Constant getConstExpr() {
    return constExpr;
  }


  @JsonProperty(JSON_PROPERTY_CONST_EXPR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConstExpr(Constant constExpr) {
    this.constExpr = constExpr;
  }


  public Expr identExpr(Ident identExpr) {
    this.identExpr = identExpr;
    return this;
  }

   /**
   * Get identExpr
   * @return identExpr
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IDENT_EXPR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Ident getIdentExpr() {
    return identExpr;
  }


  @JsonProperty(JSON_PROPERTY_IDENT_EXPR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentExpr(Ident identExpr) {
    this.identExpr = identExpr;
  }


  public Expr selectExpr(Select selectExpr) {
    this.selectExpr = selectExpr;
    return this;
  }

   /**
   * Get selectExpr
   * @return selectExpr
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SELECT_EXPR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Select getSelectExpr() {
    return selectExpr;
  }


  @JsonProperty(JSON_PROPERTY_SELECT_EXPR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelectExpr(Select selectExpr) {
    this.selectExpr = selectExpr;
  }


  public Expr callExpr(ExprCall callExpr) {
    this.callExpr = callExpr;
    return this;
  }

   /**
   * Get callExpr
   * @return callExpr
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CALL_EXPR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ExprCall getCallExpr() {
    return callExpr;
  }


  @JsonProperty(JSON_PROPERTY_CALL_EXPR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCallExpr(ExprCall callExpr) {
    this.callExpr = callExpr;
  }


  public Expr listExpr(CreateList listExpr) {
    this.listExpr = listExpr;
    return this;
  }

   /**
   * Get listExpr
   * @return listExpr
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LIST_EXPR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CreateList getListExpr() {
    return listExpr;
  }


  @JsonProperty(JSON_PROPERTY_LIST_EXPR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setListExpr(CreateList listExpr) {
    this.listExpr = listExpr;
  }


  public Expr structExpr(CreateStruct structExpr) {
    this.structExpr = structExpr;
    return this;
  }

   /**
   * Get structExpr
   * @return structExpr
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STRUCT_EXPR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CreateStruct getStructExpr() {
    return structExpr;
  }


  @JsonProperty(JSON_PROPERTY_STRUCT_EXPR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStructExpr(CreateStruct structExpr) {
    this.structExpr = structExpr;
  }


  public Expr comprehensionExpr(Comprehension comprehensionExpr) {
    this.comprehensionExpr = comprehensionExpr;
    return this;
  }

   /**
   * Get comprehensionExpr
   * @return comprehensionExpr
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COMPREHENSION_EXPR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Comprehension getComprehensionExpr() {
    return comprehensionExpr;
  }


  @JsonProperty(JSON_PROPERTY_COMPREHENSION_EXPR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setComprehensionExpr(Comprehension comprehensionExpr) {
    this.comprehensionExpr = comprehensionExpr;
  }


  /**
   * Return true if this Expr object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Expr expr = (Expr) o;
    return Objects.equals(this.id, expr.id) &&
        Objects.equals(this.constExpr, expr.constExpr) &&
        Objects.equals(this.identExpr, expr.identExpr) &&
        Objects.equals(this.selectExpr, expr.selectExpr) &&
        Objects.equals(this.callExpr, expr.callExpr) &&
        Objects.equals(this.listExpr, expr.listExpr) &&
        Objects.equals(this.structExpr, expr.structExpr) &&
        Objects.equals(this.comprehensionExpr, expr.comprehensionExpr);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, constExpr, identExpr, selectExpr, callExpr, listExpr, structExpr, comprehensionExpr);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Expr {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    constExpr: ").append(toIndentedString(constExpr)).append("\n");
    sb.append("    identExpr: ").append(toIndentedString(identExpr)).append("\n");
    sb.append("    selectExpr: ").append(toIndentedString(selectExpr)).append("\n");
    sb.append("    callExpr: ").append(toIndentedString(callExpr)).append("\n");
    sb.append("    listExpr: ").append(toIndentedString(listExpr)).append("\n");
    sb.append("    structExpr: ").append(toIndentedString(structExpr)).append("\n");
    sb.append("    comprehensionExpr: ").append(toIndentedString(comprehensionExpr)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `constExpr` to the URL query string
    if (getConstExpr() != null) {
      joiner.add(getConstExpr().toUrlQueryString(prefix + "constExpr" + suffix));
    }

    // add `identExpr` to the URL query string
    if (getIdentExpr() != null) {
      joiner.add(getIdentExpr().toUrlQueryString(prefix + "identExpr" + suffix));
    }

    // add `selectExpr` to the URL query string
    if (getSelectExpr() != null) {
      joiner.add(getSelectExpr().toUrlQueryString(prefix + "selectExpr" + suffix));
    }

    // add `callExpr` to the URL query string
    if (getCallExpr() != null) {
      joiner.add(getCallExpr().toUrlQueryString(prefix + "callExpr" + suffix));
    }

    // add `listExpr` to the URL query string
    if (getListExpr() != null) {
      joiner.add(getListExpr().toUrlQueryString(prefix + "listExpr" + suffix));
    }

    // add `structExpr` to the URL query string
    if (getStructExpr() != null) {
      joiner.add(getStructExpr().toUrlQueryString(prefix + "structExpr" + suffix));
    }

    // add `comprehensionExpr` to the URL query string
    if (getComprehensionExpr() != null) {
      joiner.add(getComprehensionExpr().toUrlQueryString(prefix + "comprehensionExpr" + suffix));
    }

    return joiner.toString();
  }
}

