/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.4.4
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.ComputedAttribute;
import co.permify.sdk.model.ComputedUserSet;
import co.permify.sdk.model.TupleToUserSet;
import co.permify.sdk.model.V1Call;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Leaf represents a leaf node in the permission tree.
 */
@JsonPropertyOrder({
  Leaf.JSON_PROPERTY_COMPUTED_USER_SET,
  Leaf.JSON_PROPERTY_TUPLE_TO_USER_SET,
  Leaf.JSON_PROPERTY_COMPUTED_ATTRIBUTE,
  Leaf.JSON_PROPERTY_CALL
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class Leaf {
  public static final String JSON_PROPERTY_COMPUTED_USER_SET = "computedUserSet";
  private ComputedUserSet computedUserSet;

  public static final String JSON_PROPERTY_TUPLE_TO_USER_SET = "tupleToUserSet";
  private TupleToUserSet tupleToUserSet;

  public static final String JSON_PROPERTY_COMPUTED_ATTRIBUTE = "computedAttribute";
  private ComputedAttribute computedAttribute;

  public static final String JSON_PROPERTY_CALL = "call";
  private V1Call call;

  public Leaf() { 
  }

  public Leaf computedUserSet(ComputedUserSet computedUserSet) {
    this.computedUserSet = computedUserSet;
    return this;
  }

   /**
   * Get computedUserSet
   * @return computedUserSet
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COMPUTED_USER_SET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ComputedUserSet getComputedUserSet() {
    return computedUserSet;
  }


  @JsonProperty(JSON_PROPERTY_COMPUTED_USER_SET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setComputedUserSet(ComputedUserSet computedUserSet) {
    this.computedUserSet = computedUserSet;
  }


  public Leaf tupleToUserSet(TupleToUserSet tupleToUserSet) {
    this.tupleToUserSet = tupleToUserSet;
    return this;
  }

   /**
   * Get tupleToUserSet
   * @return tupleToUserSet
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TUPLE_TO_USER_SET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TupleToUserSet getTupleToUserSet() {
    return tupleToUserSet;
  }


  @JsonProperty(JSON_PROPERTY_TUPLE_TO_USER_SET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTupleToUserSet(TupleToUserSet tupleToUserSet) {
    this.tupleToUserSet = tupleToUserSet;
  }


  public Leaf computedAttribute(ComputedAttribute computedAttribute) {
    this.computedAttribute = computedAttribute;
    return this;
  }

   /**
   * Get computedAttribute
   * @return computedAttribute
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COMPUTED_ATTRIBUTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ComputedAttribute getComputedAttribute() {
    return computedAttribute;
  }


  @JsonProperty(JSON_PROPERTY_COMPUTED_ATTRIBUTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setComputedAttribute(ComputedAttribute computedAttribute) {
    this.computedAttribute = computedAttribute;
  }


  public Leaf call(V1Call call) {
    this.call = call;
    return this;
  }

   /**
   * Get call
   * @return call
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CALL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public V1Call getCall() {
    return call;
  }


  @JsonProperty(JSON_PROPERTY_CALL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCall(V1Call call) {
    this.call = call;
  }


  /**
   * Return true if this Leaf object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Leaf leaf = (Leaf) o;
    return Objects.equals(this.computedUserSet, leaf.computedUserSet) &&
        Objects.equals(this.tupleToUserSet, leaf.tupleToUserSet) &&
        Objects.equals(this.computedAttribute, leaf.computedAttribute) &&
        Objects.equals(this.call, leaf.call);
  }

  @Override
  public int hashCode() {
    return Objects.hash(computedUserSet, tupleToUserSet, computedAttribute, call);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Leaf {\n");
    sb.append("    computedUserSet: ").append(toIndentedString(computedUserSet)).append("\n");
    sb.append("    tupleToUserSet: ").append(toIndentedString(tupleToUserSet)).append("\n");
    sb.append("    computedAttribute: ").append(toIndentedString(computedAttribute)).append("\n");
    sb.append("    call: ").append(toIndentedString(call)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `computedUserSet` to the URL query string
    if (getComputedUserSet() != null) {
      joiner.add(getComputedUserSet().toUrlQueryString(prefix + "computedUserSet" + suffix));
    }

    // add `tupleToUserSet` to the URL query string
    if (getTupleToUserSet() != null) {
      joiner.add(getTupleToUserSet().toUrlQueryString(prefix + "tupleToUserSet" + suffix));
    }

    // add `computedAttribute` to the URL query string
    if (getComputedAttribute() != null) {
      joiner.add(getComputedAttribute().toUrlQueryString(prefix + "computedAttribute" + suffix));
    }

    // add `call` to the URL query string
    if (getCall() != null) {
      joiner.add(getCall().toUrlQueryString(prefix + "call" + suffix));
    }

    return joiner.toString();
  }
}

