/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.4.4
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Argument;
import co.permify.sdk.model.Context;
import co.permify.sdk.model.Entity;
import co.permify.sdk.model.PermissionExpandRequestMetadata;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * PermissionExpandRequest is the request message for the Expand method in the Permission service.
 */
@JsonPropertyOrder({
  PermissionExpandBody.JSON_PROPERTY_METADATA,
  PermissionExpandBody.JSON_PROPERTY_ENTITY,
  PermissionExpandBody.JSON_PROPERTY_PERMISSION,
  PermissionExpandBody.JSON_PROPERTY_CONTEXT,
  PermissionExpandBody.JSON_PROPERTY_ARGUMENTS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class PermissionExpandBody {
  public static final String JSON_PROPERTY_METADATA = "metadata";
  private PermissionExpandRequestMetadata metadata;

  public static final String JSON_PROPERTY_ENTITY = "entity";
  private Entity entity;

  public static final String JSON_PROPERTY_PERMISSION = "permission";
  private String permission;

  public static final String JSON_PROPERTY_CONTEXT = "context";
  private Context context;

  public static final String JSON_PROPERTY_ARGUMENTS = "arguments";
  private List<Argument> arguments;

  public PermissionExpandBody() { 
  }

  public PermissionExpandBody metadata(PermissionExpandRequestMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PermissionExpandRequestMetadata getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(PermissionExpandRequestMetadata metadata) {
    this.metadata = metadata;
  }


  public PermissionExpandBody entity(Entity entity) {
    this.entity = entity;
    return this;
  }

   /**
   * Get entity
   * @return entity
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ENTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Entity getEntity() {
    return entity;
  }


  @JsonProperty(JSON_PROPERTY_ENTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEntity(Entity entity) {
    this.entity = entity;
  }


  public PermissionExpandBody permission(String permission) {
    this.permission = permission;
    return this;
  }

   /**
   * Name of the permission to be expanded, not required, must start with a letter and can include alphanumeric and underscore, max 64 bytes.
   * @return permission
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PERMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPermission() {
    return permission;
  }


  @JsonProperty(JSON_PROPERTY_PERMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPermission(String permission) {
    this.permission = permission;
  }


  public PermissionExpandBody context(Context context) {
    this.context = context;
    return this;
  }

   /**
   * Get context
   * @return context
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Context getContext() {
    return context;
  }


  @JsonProperty(JSON_PROPERTY_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContext(Context context) {
    this.context = context;
  }


  public PermissionExpandBody arguments(List<Argument> arguments) {
    this.arguments = arguments;
    return this;
  }

  public PermissionExpandBody addArgumentsItem(Argument argumentsItem) {
    if (this.arguments == null) {
      this.arguments = new ArrayList<>();
    }
    this.arguments.add(argumentsItem);
    return this;
  }

   /**
   * Additional arguments associated with this request.
   * @return arguments
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ARGUMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Argument> getArguments() {
    return arguments;
  }


  @JsonProperty(JSON_PROPERTY_ARGUMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArguments(List<Argument> arguments) {
    this.arguments = arguments;
  }


  /**
   * Return true if this Permission.ExpandBody object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PermissionExpandBody permissionExpandBody = (PermissionExpandBody) o;
    return Objects.equals(this.metadata, permissionExpandBody.metadata) &&
        Objects.equals(this.entity, permissionExpandBody.entity) &&
        Objects.equals(this.permission, permissionExpandBody.permission) &&
        Objects.equals(this.context, permissionExpandBody.context) &&
        Objects.equals(this.arguments, permissionExpandBody.arguments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(metadata, entity, permission, context, arguments);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PermissionExpandBody {\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    entity: ").append(toIndentedString(entity)).append("\n");
    sb.append("    permission: ").append(toIndentedString(permission)).append("\n");
    sb.append("    context: ").append(toIndentedString(context)).append("\n");
    sb.append("    arguments: ").append(toIndentedString(arguments)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `metadata` to the URL query string
    if (getMetadata() != null) {
      joiner.add(getMetadata().toUrlQueryString(prefix + "metadata" + suffix));
    }

    // add `entity` to the URL query string
    if (getEntity() != null) {
      joiner.add(getEntity().toUrlQueryString(prefix + "entity" + suffix));
    }

    // add `permission` to the URL query string
    if (getPermission() != null) {
      joiner.add(String.format("%spermission%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPermission()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `context` to the URL query string
    if (getContext() != null) {
      joiner.add(getContext().toUrlQueryString(prefix + "context" + suffix));
    }

    // add `arguments` to the URL query string
    if (getArguments() != null) {
      for (int i = 0; i < getArguments().size(); i++) {
        if (getArguments().get(i) != null) {
          joiner.add(getArguments().get(i).toUrlQueryString(String.format("%sarguments%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }
}

