/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.4.4
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Argument;
import co.permify.sdk.model.Entity;
import co.permify.sdk.model.ExpandLeaf;
import co.permify.sdk.model.ExpandTreeNode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Expand is used to define a hierarchical structure for permissions. It has an entity, permission, and arguments. The node can be either another hierarchical structure or a set of subjects.
 */
@JsonPropertyOrder({
  V1Expand.JSON_PROPERTY_ENTITY,
  V1Expand.JSON_PROPERTY_PERMISSION,
  V1Expand.JSON_PROPERTY_ARGUMENTS,
  V1Expand.JSON_PROPERTY_EXPAND,
  V1Expand.JSON_PROPERTY_LEAF
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class V1Expand {
  public static final String JSON_PROPERTY_ENTITY = "entity";
  private Entity entity;

  public static final String JSON_PROPERTY_PERMISSION = "permission";
  private String permission;

  public static final String JSON_PROPERTY_ARGUMENTS = "arguments";
  private List<Argument> arguments;

  public static final String JSON_PROPERTY_EXPAND = "expand";
  private ExpandTreeNode expand;

  public static final String JSON_PROPERTY_LEAF = "leaf";
  private ExpandLeaf leaf;

  public V1Expand() { 
  }

  public V1Expand entity(Entity entity) {
    this.entity = entity;
    return this;
  }

   /**
   * Get entity
   * @return entity
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ENTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Entity getEntity() {
    return entity;
  }


  @JsonProperty(JSON_PROPERTY_ENTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEntity(Entity entity) {
    this.entity = entity;
  }


  public V1Expand permission(String permission) {
    this.permission = permission;
    return this;
  }

   /**
   * permission is the permission applied to the entity.
   * @return permission
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PERMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPermission() {
    return permission;
  }


  @JsonProperty(JSON_PROPERTY_PERMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPermission(String permission) {
    this.permission = permission;
  }


  public V1Expand arguments(List<Argument> arguments) {
    this.arguments = arguments;
    return this;
  }

  public V1Expand addArgumentsItem(Argument argumentsItem) {
    if (this.arguments == null) {
      this.arguments = new ArrayList<>();
    }
    this.arguments.add(argumentsItem);
    return this;
  }

   /**
   * arguments are the additional information or context used to evaluate permissions.
   * @return arguments
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ARGUMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Argument> getArguments() {
    return arguments;
  }


  @JsonProperty(JSON_PROPERTY_ARGUMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArguments(List<Argument> arguments) {
    this.arguments = arguments;
  }


  public V1Expand expand(ExpandTreeNode expand) {
    this.expand = expand;
    return this;
  }

   /**
   * Get expand
   * @return expand
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXPAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ExpandTreeNode getExpand() {
    return expand;
  }


  @JsonProperty(JSON_PROPERTY_EXPAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpand(ExpandTreeNode expand) {
    this.expand = expand;
  }


  public V1Expand leaf(ExpandLeaf leaf) {
    this.leaf = leaf;
    return this;
  }

   /**
   * Get leaf
   * @return leaf
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LEAF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ExpandLeaf getLeaf() {
    return leaf;
  }


  @JsonProperty(JSON_PROPERTY_LEAF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLeaf(ExpandLeaf leaf) {
    this.leaf = leaf;
  }


  /**
   * Return true if this v1.Expand object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1Expand v1Expand = (V1Expand) o;
    return Objects.equals(this.entity, v1Expand.entity) &&
        Objects.equals(this.permission, v1Expand.permission) &&
        Objects.equals(this.arguments, v1Expand.arguments) &&
        Objects.equals(this.expand, v1Expand.expand) &&
        Objects.equals(this.leaf, v1Expand.leaf);
  }

  @Override
  public int hashCode() {
    return Objects.hash(entity, permission, arguments, expand, leaf);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1Expand {\n");
    sb.append("    entity: ").append(toIndentedString(entity)).append("\n");
    sb.append("    permission: ").append(toIndentedString(permission)).append("\n");
    sb.append("    arguments: ").append(toIndentedString(arguments)).append("\n");
    sb.append("    expand: ").append(toIndentedString(expand)).append("\n");
    sb.append("    leaf: ").append(toIndentedString(leaf)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `entity` to the URL query string
    if (getEntity() != null) {
      joiner.add(getEntity().toUrlQueryString(prefix + "entity" + suffix));
    }

    // add `permission` to the URL query string
    if (getPermission() != null) {
      joiner.add(String.format("%spermission%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPermission()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `arguments` to the URL query string
    if (getArguments() != null) {
      for (int i = 0; i < getArguments().size(); i++) {
        if (getArguments().get(i) != null) {
          joiner.add(getArguments().get(i).toUrlQueryString(String.format("%sarguments%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `expand` to the URL query string
    if (getExpand() != null) {
      joiner.add(getExpand().toUrlQueryString(prefix + "expand" + suffix));
    }

    // add `leaf` to the URL query string
    if (getLeaf() != null) {
      joiner.add(getLeaf().toUrlQueryString(prefix + "leaf" + suffix));
    }

    return joiner.toString();
  }
}

