/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.4.4
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Operation is a message representing a series of operations that can be performed. It includes fields for writing and deleting relationships and attributes.
 */
@JsonPropertyOrder({
  V1Operation.JSON_PROPERTY_RELATIONSHIPS_WRITE,
  V1Operation.JSON_PROPERTY_RELATIONSHIPS_DELETE,
  V1Operation.JSON_PROPERTY_ATTRIBUTES_WRITE,
  V1Operation.JSON_PROPERTY_ATTRIBUTES_DELETE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class V1Operation {
  public static final String JSON_PROPERTY_RELATIONSHIPS_WRITE = "relationships_write";
  private List<String> relationshipsWrite;

  public static final String JSON_PROPERTY_RELATIONSHIPS_DELETE = "relationships_delete";
  private List<String> relationshipsDelete;

  public static final String JSON_PROPERTY_ATTRIBUTES_WRITE = "attributes_write";
  private List<String> attributesWrite;

  public static final String JSON_PROPERTY_ATTRIBUTES_DELETE = "attributes_delete";
  private List<String> attributesDelete;

  public V1Operation() { 
  }

  public V1Operation relationshipsWrite(List<String> relationshipsWrite) {
    this.relationshipsWrite = relationshipsWrite;
    return this;
  }

  public V1Operation addRelationshipsWriteItem(String relationshipsWriteItem) {
    if (this.relationshipsWrite == null) {
      this.relationshipsWrite = new ArrayList<>();
    }
    this.relationshipsWrite.add(relationshipsWriteItem);
    return this;
  }

   /**
   * &#39;relationships_write&#39; is a repeated string field for storing relationship keys that are to be written or created.
   * @return relationshipsWrite
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RELATIONSHIPS_WRITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRelationshipsWrite() {
    return relationshipsWrite;
  }


  @JsonProperty(JSON_PROPERTY_RELATIONSHIPS_WRITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRelationshipsWrite(List<String> relationshipsWrite) {
    this.relationshipsWrite = relationshipsWrite;
  }


  public V1Operation relationshipsDelete(List<String> relationshipsDelete) {
    this.relationshipsDelete = relationshipsDelete;
    return this;
  }

  public V1Operation addRelationshipsDeleteItem(String relationshipsDeleteItem) {
    if (this.relationshipsDelete == null) {
      this.relationshipsDelete = new ArrayList<>();
    }
    this.relationshipsDelete.add(relationshipsDeleteItem);
    return this;
  }

   /**
   * &#39;relationships_delete&#39; is a repeated string field for storing relationship keys that are to be deleted or removed.
   * @return relationshipsDelete
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RELATIONSHIPS_DELETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRelationshipsDelete() {
    return relationshipsDelete;
  }


  @JsonProperty(JSON_PROPERTY_RELATIONSHIPS_DELETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRelationshipsDelete(List<String> relationshipsDelete) {
    this.relationshipsDelete = relationshipsDelete;
  }


  public V1Operation attributesWrite(List<String> attributesWrite) {
    this.attributesWrite = attributesWrite;
    return this;
  }

  public V1Operation addAttributesWriteItem(String attributesWriteItem) {
    if (this.attributesWrite == null) {
      this.attributesWrite = new ArrayList<>();
    }
    this.attributesWrite.add(attributesWriteItem);
    return this;
  }

   /**
   * &#39;attributes_write&#39; is a repeated string field for storing attribute keys that are to be written or created.
   * @return attributesWrite
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES_WRITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAttributesWrite() {
    return attributesWrite;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTES_WRITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributesWrite(List<String> attributesWrite) {
    this.attributesWrite = attributesWrite;
  }


  public V1Operation attributesDelete(List<String> attributesDelete) {
    this.attributesDelete = attributesDelete;
    return this;
  }

  public V1Operation addAttributesDeleteItem(String attributesDeleteItem) {
    if (this.attributesDelete == null) {
      this.attributesDelete = new ArrayList<>();
    }
    this.attributesDelete.add(attributesDeleteItem);
    return this;
  }

   /**
   * &#39;attributes_delete&#39; is a repeated string field for storing attribute keys that are to be deleted or removed.
   * @return attributesDelete
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES_DELETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAttributesDelete() {
    return attributesDelete;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTES_DELETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributesDelete(List<String> attributesDelete) {
    this.attributesDelete = attributesDelete;
  }


  /**
   * Return true if this v1.Operation object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1Operation v1Operation = (V1Operation) o;
    return Objects.equals(this.relationshipsWrite, v1Operation.relationshipsWrite) &&
        Objects.equals(this.relationshipsDelete, v1Operation.relationshipsDelete) &&
        Objects.equals(this.attributesWrite, v1Operation.attributesWrite) &&
        Objects.equals(this.attributesDelete, v1Operation.attributesDelete);
  }

  @Override
  public int hashCode() {
    return Objects.hash(relationshipsWrite, relationshipsDelete, attributesWrite, attributesDelete);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1Operation {\n");
    sb.append("    relationshipsWrite: ").append(toIndentedString(relationshipsWrite)).append("\n");
    sb.append("    relationshipsDelete: ").append(toIndentedString(relationshipsDelete)).append("\n");
    sb.append("    attributesWrite: ").append(toIndentedString(attributesWrite)).append("\n");
    sb.append("    attributesDelete: ").append(toIndentedString(attributesDelete)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `relationships_write` to the URL query string
    if (getRelationshipsWrite() != null) {
      for (int i = 0; i < getRelationshipsWrite().size(); i++) {
        joiner.add(String.format("%srelationships_write%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
            URLEncoder.encode(String.valueOf(getRelationshipsWrite().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `relationships_delete` to the URL query string
    if (getRelationshipsDelete() != null) {
      for (int i = 0; i < getRelationshipsDelete().size(); i++) {
        joiner.add(String.format("%srelationships_delete%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
            URLEncoder.encode(String.valueOf(getRelationshipsDelete().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `attributes_write` to the URL query string
    if (getAttributesWrite() != null) {
      for (int i = 0; i < getAttributesWrite().size(); i++) {
        joiner.add(String.format("%sattributes_write%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
            URLEncoder.encode(String.valueOf(getAttributesWrite().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `attributes_delete` to the URL query string
    if (getAttributesDelete() != null) {
      for (int i = 0; i < getAttributesDelete().size(); i++) {
        joiner.add(String.format("%sattributes_delete%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
            URLEncoder.encode(String.valueOf(getAttributesDelete().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    return joiner.toString();
  }
}

