/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.api;

import co.permify.sdk.client.ApiClient;
import co.permify.sdk.client.ApiException;
import co.permify.sdk.client.ApiResponse;
import co.permify.sdk.model.TenantCreateRequest;
import co.permify.sdk.model.TenantCreateResponse;
import co.permify.sdk.model.TenantDeleteResponse;
import co.permify.sdk.model.TenantListRequest;
import co.permify.sdk.model.TenantListResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.function.Consumer;

public class TenancyApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public TenancyApi() {
        this(new ApiClient());
    }

    public TenancyApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public TenantCreateResponse tenantsCreate(TenantCreateRequest body) throws ApiException {
        ApiResponse<TenantCreateResponse> localVarResponse = this.tenantsCreateWithHttpInfo(body);
        return localVarResponse.getData();
    }

    public ApiResponse<TenantCreateResponse> tenantsCreateWithHttpInfo(TenantCreateRequest body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.tenantsCreateRequestBuilder(body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("tenantsCreate", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (TenantCreateResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<TenantCreateResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder tenantsCreateRequestBuilder(TenantCreateRequest body) throws ApiException {
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling tenantsCreate");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/create";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public TenantDeleteResponse tenantsDelete(String id) throws ApiException {
        ApiResponse<TenantDeleteResponse> localVarResponse = this.tenantsDeleteWithHttpInfo(id);
        return localVarResponse.getData();
    }

    public ApiResponse<TenantDeleteResponse> tenantsDeleteWithHttpInfo(String id) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.tenantsDeleteRequestBuilder(id);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("tenantsDelete", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (TenantDeleteResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<TenantDeleteResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder tenantsDeleteRequestBuilder(String id) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling tenantsDelete");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/{id}".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public TenantListResponse tenantsList(TenantListRequest body) throws ApiException {
        ApiResponse<TenantListResponse> localVarResponse = this.tenantsListWithHttpInfo(body);
        return localVarResponse.getData();
    }

    public ApiResponse<TenantListResponse> tenantsListWithHttpInfo(TenantListRequest body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.tenantsListRequestBuilder(body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("tenantsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (TenantListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<TenantListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder tenantsListRequestBuilder(TenantListRequest body) throws ApiException {
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling tenantsList");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/v1/tenants/list";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

