/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.model.Context;
import co.permify.sdk.model.PermissionLookupEntityRequestMetadata;
import co.permify.sdk.model.StringArrayValue;
import co.permify.sdk.model.Subject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"metadata", "entity_type", "permission", "subject", "context", "scope", "page_size", "continuous_token"})
public class LookupEntityBody {
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private PermissionLookupEntityRequestMetadata metadata;
    public static final String JSON_PROPERTY_ENTITY_TYPE = "entity_type";
    private String entityType;
    public static final String JSON_PROPERTY_PERMISSION = "permission";
    private String permission;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private Subject subject;
    public static final String JSON_PROPERTY_CONTEXT = "context";
    private Context context;
    public static final String JSON_PROPERTY_SCOPE = "scope";
    private Map<String, StringArrayValue> scope = new HashMap<String, StringArrayValue>();
    public static final String JSON_PROPERTY_PAGE_SIZE = "page_size";
    private Long pageSize;
    public static final String JSON_PROPERTY_CONTINUOUS_TOKEN = "continuous_token";
    private String continuousToken;

    public LookupEntityBody metadata(PermissionLookupEntityRequestMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PermissionLookupEntityRequestMetadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(PermissionLookupEntityRequestMetadata metadata) {
        this.metadata = metadata;
    }

    public LookupEntityBody entityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    @Nullable
    @JsonProperty(value="entity_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entity_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public LookupEntityBody permission(String permission) {
        this.permission = permission;
        return this;
    }

    @Nullable
    @JsonProperty(value="permission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPermission() {
        return this.permission;
    }

    @JsonProperty(value="permission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPermission(String permission) {
        this.permission = permission;
    }

    public LookupEntityBody subject(Subject subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Subject getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public LookupEntityBody context(Context context) {
        this.context = context;
        return this;
    }

    @Nullable
    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Context getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContext(Context context) {
        this.context = context;
    }

    public LookupEntityBody scope(Map<String, StringArrayValue> scope) {
        this.scope = scope;
        return this;
    }

    public LookupEntityBody putScopeItem(String key, StringArrayValue scopeItem) {
        if (this.scope == null) {
            this.scope = new HashMap<String, StringArrayValue>();
        }
        this.scope.put(key, scopeItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, StringArrayValue> getScope() {
        return this.scope;
    }

    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScope(Map<String, StringArrayValue> scope) {
        this.scope = scope;
    }

    public LookupEntityBody pageSize(Long pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="page_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="page_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageSize(Long pageSize) {
        this.pageSize = pageSize;
    }

    public LookupEntityBody continuousToken(String continuousToken) {
        this.continuousToken = continuousToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="continuous_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContinuousToken() {
        return this.continuousToken;
    }

    @JsonProperty(value="continuous_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContinuousToken(String continuousToken) {
        this.continuousToken = continuousToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupEntityBody lookupEntityBody = (LookupEntityBody)o;
        return Objects.equals(this.metadata, lookupEntityBody.metadata) && Objects.equals(this.entityType, lookupEntityBody.entityType) && Objects.equals(this.permission, lookupEntityBody.permission) && Objects.equals(this.subject, lookupEntityBody.subject) && Objects.equals(this.context, lookupEntityBody.context) && Objects.equals(this.scope, lookupEntityBody.scope) && Objects.equals(this.pageSize, lookupEntityBody.pageSize) && Objects.equals(this.continuousToken, lookupEntityBody.continuousToken);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.entityType, this.permission, this.subject, this.context, this.scope, this.pageSize, this.continuousToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LookupEntityBody {\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString(this.entityType)).append("\n");
        sb.append("    permission: ").append(this.toIndentedString(this.permission)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    continuousToken: ").append(this.toIndentedString(this.continuousToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getMetadata() != null) {
            joiner.add(this.getMetadata().toUrlQueryString((String)prefix + JSON_PROPERTY_METADATA + suffix));
        }
        if (this.getEntityType() != null) {
            joiner.add(String.format("%sentity_type%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEntityType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPermission() != null) {
            joiner.add(String.format("%spermission%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPermission()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSubject() != null) {
            joiner.add(this.getSubject().toUrlQueryString((String)prefix + JSON_PROPERTY_SUBJECT + suffix));
        }
        if (this.getContext() != null) {
            joiner.add(this.getContext().toUrlQueryString((String)prefix + JSON_PROPERTY_CONTEXT + suffix));
        }
        if (this.getScope() != null) {
            for (String _key : this.getScope().keySet()) {
                if (this.getScope().get(_key) == null) continue;
                joiner.add(this.getScope().get(_key).toUrlQueryString(String.format("%sscope%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getPageSize() != null) {
            joiner.add(String.format("%spage_size%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPageSize()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getContinuousToken() != null) {
            joiner.add(String.format("%scontinuous_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getContinuousToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

