/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.model.AttributeType;
import co.permify.sdk.model.CheckedExpr;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "arguments", "expression"})
public class RuleDefinition {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ARGUMENTS = "arguments";
    private Map<String, AttributeType> arguments = new HashMap<String, AttributeType>();
    public static final String JSON_PROPERTY_EXPRESSION = "expression";
    private CheckedExpr expression;

    public RuleDefinition name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public RuleDefinition arguments(Map<String, AttributeType> arguments) {
        this.arguments = arguments;
        return this;
    }

    public RuleDefinition putArgumentsItem(String key, AttributeType argumentsItem) {
        if (this.arguments == null) {
            this.arguments = new HashMap<String, AttributeType>();
        }
        this.arguments.put(key, argumentsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="arguments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, AttributeType> getArguments() {
        return this.arguments;
    }

    @JsonProperty(value="arguments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArguments(Map<String, AttributeType> arguments) {
        this.arguments = arguments;
    }

    public RuleDefinition expression(CheckedExpr expression) {
        this.expression = expression;
        return this;
    }

    @Nullable
    @JsonProperty(value="expression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CheckedExpr getExpression() {
        return this.expression;
    }

    @JsonProperty(value="expression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpression(CheckedExpr expression) {
        this.expression = expression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleDefinition ruleDefinition = (RuleDefinition)o;
        return Objects.equals(this.name, ruleDefinition.name) && Objects.equals(this.arguments, ruleDefinition.arguments) && Objects.equals(this.expression, ruleDefinition.expression);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.arguments, this.expression);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RuleDefinition {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("    expression: ").append(this.toIndentedString(this.expression)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getArguments() != null) {
            for (String _key : this.getArguments().keySet()) {
                joiner.add(String.format("%sarguments%s%s=%s", new Object[]{prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getArguments().get(_key), URLEncoder.encode(String.valueOf((Object)this.getArguments().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")}));
            }
        }
        if (this.getExpression() != null) {
            joiner.add(this.getExpression().toUrlQueryString((String)prefix + JSON_PROPERTY_EXPRESSION + suffix));
        }
        return joiner.toString();
    }
}

