/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.model.Expr;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"syntaxVersion", "location", "lineOffsets", "positions", "macroCalls"})
public class SourceInfo {
    public static final String JSON_PROPERTY_SYNTAX_VERSION = "syntaxVersion";
    private String syntaxVersion;
    public static final String JSON_PROPERTY_LOCATION = "location";
    private String location;
    public static final String JSON_PROPERTY_LINE_OFFSETS = "lineOffsets";
    private List<Integer> lineOffsets;
    public static final String JSON_PROPERTY_POSITIONS = "positions";
    private Map<String, Integer> positions = new HashMap<String, Integer>();
    public static final String JSON_PROPERTY_MACRO_CALLS = "macroCalls";
    private Map<String, Expr> macroCalls = new HashMap<String, Expr>();

    public SourceInfo syntaxVersion(String syntaxVersion) {
        this.syntaxVersion = syntaxVersion;
        return this;
    }

    @Nullable
    @JsonProperty(value="syntaxVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSyntaxVersion() {
        return this.syntaxVersion;
    }

    @JsonProperty(value="syntaxVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSyntaxVersion(String syntaxVersion) {
        this.syntaxVersion = syntaxVersion;
    }

    public SourceInfo location(String location) {
        this.location = location;
        return this;
    }

    @Nullable
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocation(String location) {
        this.location = location;
    }

    public SourceInfo lineOffsets(List<Integer> lineOffsets) {
        this.lineOffsets = lineOffsets;
        return this;
    }

    public SourceInfo addLineOffsetsItem(Integer lineOffsetsItem) {
        if (this.lineOffsets == null) {
            this.lineOffsets = new ArrayList<Integer>();
        }
        this.lineOffsets.add(lineOffsetsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="lineOffsets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Integer> getLineOffsets() {
        return this.lineOffsets;
    }

    @JsonProperty(value="lineOffsets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLineOffsets(List<Integer> lineOffsets) {
        this.lineOffsets = lineOffsets;
    }

    public SourceInfo positions(Map<String, Integer> positions) {
        this.positions = positions;
        return this;
    }

    public SourceInfo putPositionsItem(String key, Integer positionsItem) {
        if (this.positions == null) {
            this.positions = new HashMap<String, Integer>();
        }
        this.positions.put(key, positionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="positions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Integer> getPositions() {
        return this.positions;
    }

    @JsonProperty(value="positions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPositions(Map<String, Integer> positions) {
        this.positions = positions;
    }

    public SourceInfo macroCalls(Map<String, Expr> macroCalls) {
        this.macroCalls = macroCalls;
        return this;
    }

    public SourceInfo putMacroCallsItem(String key, Expr macroCallsItem) {
        if (this.macroCalls == null) {
            this.macroCalls = new HashMap<String, Expr>();
        }
        this.macroCalls.put(key, macroCallsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="macroCalls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Expr> getMacroCalls() {
        return this.macroCalls;
    }

    @JsonProperty(value="macroCalls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMacroCalls(Map<String, Expr> macroCalls) {
        this.macroCalls = macroCalls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceInfo sourceInfo = (SourceInfo)o;
        return Objects.equals(this.syntaxVersion, sourceInfo.syntaxVersion) && Objects.equals(this.location, sourceInfo.location) && Objects.equals(this.lineOffsets, sourceInfo.lineOffsets) && Objects.equals(this.positions, sourceInfo.positions) && Objects.equals(this.macroCalls, sourceInfo.macroCalls);
    }

    public int hashCode() {
        return Objects.hash(this.syntaxVersion, this.location, this.lineOffsets, this.positions, this.macroCalls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceInfo {\n");
        sb.append("    syntaxVersion: ").append(this.toIndentedString(this.syntaxVersion)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    lineOffsets: ").append(this.toIndentedString(this.lineOffsets)).append("\n");
        sb.append("    positions: ").append(this.toIndentedString(this.positions)).append("\n");
        sb.append("    macroCalls: ").append(this.toIndentedString(this.macroCalls)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getSyntaxVersion() != null) {
            joiner.add(String.format("%ssyntaxVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSyntaxVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getLocation() != null) {
            joiner.add(String.format("%slocation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLocation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getLineOffsets() != null) {
            for (int i = 0; i < this.getLineOffsets().size(); ++i) {
                joiner.add(String.format("%slineOffsets%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getLineOffsets().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getPositions() != null) {
            for (String _key : this.getPositions().keySet()) {
                joiner.add(String.format("%spositions%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getPositions().get(_key), URLEncoder.encode(String.valueOf(this.getPositions().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getMacroCalls() != null) {
            for (String _key : this.getMacroCalls().keySet()) {
                if (this.getMacroCalls().get(_key) == null) continue;
                joiner.add(this.getMacroCalls().get(_key).toUrlQueryString(String.format("%smacroCalls%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

