/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.5.4
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Argument;
import co.permify.sdk.model.Context;
import co.permify.sdk.model.PermissionBulkCheckRequestItem;
import co.permify.sdk.model.PermissionCheckRequestMetadata;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * PermissionBulkCheckRequest is the request message for the BulkCheck method in the Permission service.
 */
@JsonPropertyOrder({
  BulkCheckBody.JSON_PROPERTY_METADATA,
  BulkCheckBody.JSON_PROPERTY_ITEMS,
  BulkCheckBody.JSON_PROPERTY_CONTEXT,
  BulkCheckBody.JSON_PROPERTY_ARGUMENTS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class BulkCheckBody {
  public static final String JSON_PROPERTY_METADATA = "metadata";
  private PermissionCheckRequestMetadata metadata;

  public static final String JSON_PROPERTY_ITEMS = "items";
  private List<PermissionBulkCheckRequestItem> items;

  public static final String JSON_PROPERTY_CONTEXT = "context";
  private Context context;

  public static final String JSON_PROPERTY_ARGUMENTS = "arguments";
  private List<Argument> arguments;

  public BulkCheckBody() { 
  }

  public BulkCheckBody metadata(PermissionCheckRequestMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PermissionCheckRequestMetadata getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(PermissionCheckRequestMetadata metadata) {
    this.metadata = metadata;
  }


  public BulkCheckBody items(List<PermissionBulkCheckRequestItem> items) {
    this.items = items;
    return this;
  }

  public BulkCheckBody addItemsItem(PermissionBulkCheckRequestItem itemsItem) {
    if (this.items == null) {
      this.items = new ArrayList<>();
    }
    this.items.add(itemsItem);
    return this;
  }

   /**
   * List of permission check requests, maximum 100 items.
   * @return items
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PermissionBulkCheckRequestItem> getItems() {
    return items;
  }


  @JsonProperty(JSON_PROPERTY_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setItems(List<PermissionBulkCheckRequestItem> items) {
    this.items = items;
  }


  public BulkCheckBody context(Context context) {
    this.context = context;
    return this;
  }

   /**
   * Get context
   * @return context
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Context getContext() {
    return context;
  }


  @JsonProperty(JSON_PROPERTY_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContext(Context context) {
    this.context = context;
  }


  public BulkCheckBody arguments(List<Argument> arguments) {
    this.arguments = arguments;
    return this;
  }

  public BulkCheckBody addArgumentsItem(Argument argumentsItem) {
    if (this.arguments == null) {
      this.arguments = new ArrayList<>();
    }
    this.arguments.add(argumentsItem);
    return this;
  }

   /**
   * Additional arguments associated with this request.
   * @return arguments
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ARGUMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Argument> getArguments() {
    return arguments;
  }


  @JsonProperty(JSON_PROPERTY_ARGUMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArguments(List<Argument> arguments) {
    this.arguments = arguments;
  }


  /**
   * Return true if this BulkCheckBody object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BulkCheckBody bulkCheckBody = (BulkCheckBody) o;
    return Objects.equals(this.metadata, bulkCheckBody.metadata) &&
        Objects.equals(this.items, bulkCheckBody.items) &&
        Objects.equals(this.context, bulkCheckBody.context) &&
        Objects.equals(this.arguments, bulkCheckBody.arguments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(metadata, items, context, arguments);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BulkCheckBody {\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("    context: ").append(toIndentedString(context)).append("\n");
    sb.append("    arguments: ").append(toIndentedString(arguments)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `metadata` to the URL query string
    if (getMetadata() != null) {
      joiner.add(getMetadata().toUrlQueryString(prefix + "metadata" + suffix));
    }

    // add `items` to the URL query string
    if (getItems() != null) {
      for (int i = 0; i < getItems().size(); i++) {
        if (getItems().get(i) != null) {
          joiner.add(getItems().get(i).toUrlQueryString(String.format("%sitems%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `context` to the URL query string
    if (getContext() != null) {
      joiner.add(getContext().toUrlQueryString(prefix + "context" + suffix));
    }

    // add `arguments` to the URL query string
    if (getArguments() != null) {
      for (int i = 0; i < getArguments().size(); i++) {
        if (getArguments().get(i) != null) {
          joiner.add(getArguments().get(i).toUrlQueryString(String.format("%sarguments%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }
}

