/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.5.4
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Partials;
import co.permify.sdk.model.SchemaPartialWriteRequestMetadata;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * PartialWriteBody
 */
@JsonPropertyOrder({
  PartialWriteBody.JSON_PROPERTY_METADATA,
  PartialWriteBody.JSON_PROPERTY_PARTIALS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class PartialWriteBody {
  public static final String JSON_PROPERTY_METADATA = "metadata";
  private SchemaPartialWriteRequestMetadata metadata;

  public static final String JSON_PROPERTY_PARTIALS = "partials";
  private Map<String, Partials> partials = new HashMap<>();

  public PartialWriteBody() { 
  }

  public PartialWriteBody metadata(SchemaPartialWriteRequestMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SchemaPartialWriteRequestMetadata getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(SchemaPartialWriteRequestMetadata metadata) {
    this.metadata = metadata;
  }


  public PartialWriteBody partials(Map<String, Partials> partials) {
    this.partials = partials;
    return this;
  }

  public PartialWriteBody putPartialsItem(String key, Partials partialsItem) {
    if (this.partials == null) {
      this.partials = new HashMap<>();
    }
    this.partials.put(key, partialsItem);
    return this;
  }

   /**
   * Get partials
   * @return partials
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARTIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Partials> getPartials() {
    return partials;
  }


  @JsonProperty(JSON_PROPERTY_PARTIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPartials(Map<String, Partials> partials) {
    this.partials = partials;
  }


  /**
   * Return true if this PartialWriteBody object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PartialWriteBody partialWriteBody = (PartialWriteBody) o;
    return Objects.equals(this.metadata, partialWriteBody.metadata) &&
        Objects.equals(this.partials, partialWriteBody.partials);
  }

  @Override
  public int hashCode() {
    return Objects.hash(metadata, partials);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PartialWriteBody {\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    partials: ").append(toIndentedString(partials)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `metadata` to the URL query string
    if (getMetadata() != null) {
      joiner.add(getMetadata().toUrlQueryString(prefix + "metadata" + suffix));
    }

    // add `partials` to the URL query string
    if (getPartials() != null) {
      for (String _key : getPartials().keySet()) {
        if (getPartials().get(_key) != null) {
          joiner.add(getPartials().get(_key).toUrlQueryString(String.format("%spartials%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }
}

