/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.5.4
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Entity;
import co.permify.sdk.model.Subject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * PermissionBulkCheckRequestItem
 */
@JsonPropertyOrder({
  PermissionBulkCheckRequestItem.JSON_PROPERTY_ENTITY,
  PermissionBulkCheckRequestItem.JSON_PROPERTY_PERMISSION,
  PermissionBulkCheckRequestItem.JSON_PROPERTY_SUBJECT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class PermissionBulkCheckRequestItem {
  public static final String JSON_PROPERTY_ENTITY = "entity";
  private Entity entity;

  public static final String JSON_PROPERTY_PERMISSION = "permission";
  private String permission;

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  private Subject subject;

  public PermissionBulkCheckRequestItem() { 
  }

  public PermissionBulkCheckRequestItem entity(Entity entity) {
    this.entity = entity;
    return this;
  }

   /**
   * Get entity
   * @return entity
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ENTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Entity getEntity() {
    return entity;
  }


  @JsonProperty(JSON_PROPERTY_ENTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEntity(Entity entity) {
    this.entity = entity;
  }


  public PermissionBulkCheckRequestItem permission(String permission) {
    this.permission = permission;
    return this;
  }

   /**
   * The action the user wants to perform on the resource
   * @return permission
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PERMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPermission() {
    return permission;
  }


  @JsonProperty(JSON_PROPERTY_PERMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPermission(String permission) {
    this.permission = permission;
  }


  public PermissionBulkCheckRequestItem subject(Subject subject) {
    this.subject = subject;
    return this;
  }

   /**
   * Get subject
   * @return subject
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Subject getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(Subject subject) {
    this.subject = subject;
  }


  /**
   * Return true if this PermissionBulkCheckRequestItem object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PermissionBulkCheckRequestItem permissionBulkCheckRequestItem = (PermissionBulkCheckRequestItem) o;
    return Objects.equals(this.entity, permissionBulkCheckRequestItem.entity) &&
        Objects.equals(this.permission, permissionBulkCheckRequestItem.permission) &&
        Objects.equals(this.subject, permissionBulkCheckRequestItem.subject);
  }

  @Override
  public int hashCode() {
    return Objects.hash(entity, permission, subject);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PermissionBulkCheckRequestItem {\n");
    sb.append("    entity: ").append(toIndentedString(entity)).append("\n");
    sb.append("    permission: ").append(toIndentedString(permission)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `entity` to the URL query string
    if (getEntity() != null) {
      joiner.add(getEntity().toUrlQueryString(prefix + "entity" + suffix));
    }

    // add `permission` to the URL query string
    if (getPermission() != null) {
      joiner.add(String.format("%spermission%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPermission()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `subject` to the URL query string
    if (getSubject() != null) {
      joiner.add(getSubject().toUrlQueryString(prefix + "subject" + suffix));
    }

    return joiner.toString();
  }
}

