/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.model.Component;
import co.permify.sdk.model.Version;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "affectedComponents", "version"})
public class Extension {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_AFFECTED_COMPONENTS = "affectedComponents";
    private List<Component> affectedComponents;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Version version;

    public Extension id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Extension affectedComponents(List<Component> affectedComponents) {
        this.affectedComponents = affectedComponents;
        return this;
    }

    public Extension addAffectedComponentsItem(Component affectedComponentsItem) {
        if (this.affectedComponents == null) {
            this.affectedComponents = new ArrayList<Component>();
        }
        this.affectedComponents.add(affectedComponentsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="affectedComponents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Component> getAffectedComponents() {
        return this.affectedComponents;
    }

    @JsonProperty(value="affectedComponents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAffectedComponents(List<Component> affectedComponents) {
        this.affectedComponents = affectedComponents;
    }

    public Extension version(Version version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Version getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(Version version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extension extension = (Extension)o;
        return Objects.equals(this.id, extension.id) && Objects.equals(this.affectedComponents, extension.affectedComponents) && Objects.equals(this.version, extension.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.affectedComponents, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Extension {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    affectedComponents: ").append(this.toIndentedString(this.affectedComponents)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAffectedComponents() != null) {
            for (int i = 0; i < this.getAffectedComponents().size(); ++i) {
                if (this.getAffectedComponents().get(i) == null) continue;
                joiner.add(String.format("%saffectedComponents%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf((Object)this.getAffectedComponents().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getVersion() != null) {
            joiner.add(this.getVersion().toUrlQueryString((String)prefix + JSON_PROPERTY_VERSION + suffix));
        }
        return joiner.toString();
    }
}

