/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"major", "minor"})
public class Version {
    public static final String JSON_PROPERTY_MAJOR = "major";
    private String major;
    public static final String JSON_PROPERTY_MINOR = "minor";
    private String minor;

    public Version major(String major) {
        this.major = major;
        return this;
    }

    @Nullable
    @JsonProperty(value="major")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMajor() {
        return this.major;
    }

    @JsonProperty(value="major")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMajor(String major) {
        this.major = major;
    }

    public Version minor(String minor) {
        this.minor = minor;
        return this;
    }

    @Nullable
    @JsonProperty(value="minor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMinor() {
        return this.minor;
    }

    @JsonProperty(value="minor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinor(String minor) {
        this.minor = minor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return Objects.equals(this.major, version.major) && Objects.equals(this.minor, version.minor);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Version {\n");
        sb.append("    major: ").append(this.toIndentedString(this.major)).append("\n");
        sb.append("    minor: ").append(this.toIndentedString(this.minor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getMajor() != null) {
            joiner.add(String.format("%smajor%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getMajor()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getMinor() != null) {
            joiner.add(String.format("%sminor%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getMinor()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

