/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.6.0
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package co.permify.sdk.api;

import co.permify.sdk.client.ApiClient;
import co.permify.sdk.client.ApiException;
import co.permify.sdk.client.ApiResponse;
import co.permify.sdk.client.Pair;

import co.permify.sdk.model.BulkCheckBody;
import co.permify.sdk.model.CheckBody;
import co.permify.sdk.model.LookupEntityBody;
import co.permify.sdk.model.LookupEntityStreamBody;
import co.permify.sdk.model.LookupSubjectBody;
import co.permify.sdk.model.PermissionBulkCheckResponse;
import co.permify.sdk.model.PermissionCheckResponse;
import co.permify.sdk.model.PermissionExpandBody;
import co.permify.sdk.model.PermissionExpandResponse;
import co.permify.sdk.model.PermissionLookupEntityResponse;
import co.permify.sdk.model.PermissionLookupSubjectResponse;
import co.permify.sdk.model.PermissionSubjectPermissionResponse;
import co.permify.sdk.model.Status;
import co.permify.sdk.model.StreamResultOfPermissionLookupEntityStreamResponse;
import co.permify.sdk.model.SubjectPermissionBody;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.InputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.http.HttpRequest;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class PermissionApi {
  private final HttpClient memberVarHttpClient;
  private final ObjectMapper memberVarObjectMapper;
  private final String memberVarBaseUri;
  private final Consumer<HttpRequest.Builder> memberVarInterceptor;
  private final Duration memberVarReadTimeout;
  private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
  private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

  public PermissionApi() {
    this(new ApiClient());
  }

  public PermissionApi(ApiClient apiClient) {
    memberVarHttpClient = apiClient.getHttpClient();
    memberVarObjectMapper = apiClient.getObjectMapper();
    memberVarBaseUri = apiClient.getBaseUri();
    memberVarInterceptor = apiClient.getRequestInterceptor();
    memberVarReadTimeout = apiClient.getReadTimeout();
    memberVarResponseInterceptor = apiClient.getResponseInterceptor();
    memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
  }

  protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
    String body = response.body() == null ? null : new String(response.body().readAllBytes());
    String message = formatExceptionMessage(operationId, response.statusCode(), body);
    return new ApiException(response.statusCode(), message, response.headers(), body);
  }

  private String formatExceptionMessage(String operationId, int statusCode, String body) {
    if (body == null || body.isEmpty()) {
      body = "[no body]";
    }
    return operationId + " call failed with: " + statusCode + " - " + body;
  }

  /**
   * bulk check api
   * Check multiple permissions in a single request. Maximum 100 requests allowed.
   * @param tenantId Identifier of the tenant, if you are not using multi-tenancy (have only one tenant) use pre-inserted tenant &lt;code&gt;t1&lt;/code&gt; for this field. Required, and must match the pattern \\“[a-zA-Z0-9-,]+\\“, max 64 bytes. (required)
   * @param body  (required)
   * @return PermissionBulkCheckResponse
   * @throws ApiException if fails to make API call
   */
  public PermissionBulkCheckResponse permissionsBulkCheck(String tenantId, BulkCheckBody body) throws ApiException {
    ApiResponse<PermissionBulkCheckResponse> localVarResponse = permissionsBulkCheckWithHttpInfo(tenantId, body);
    return localVarResponse.getData();
  }

  /**
   * bulk check api
   * Check multiple permissions in a single request. Maximum 100 requests allowed.
   * @param tenantId Identifier of the tenant, if you are not using multi-tenancy (have only one tenant) use pre-inserted tenant &lt;code&gt;t1&lt;/code&gt; for this field. Required, and must match the pattern \\“[a-zA-Z0-9-,]+\\“, max 64 bytes. (required)
   * @param body  (required)
   * @return ApiResponse&lt;PermissionBulkCheckResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<PermissionBulkCheckResponse> permissionsBulkCheckWithHttpInfo(String tenantId, BulkCheckBody body) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = permissionsBulkCheckRequestBuilder(tenantId, body);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("permissionsBulkCheck", localVarResponse);
        }
        return new ApiResponse<PermissionBulkCheckResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<PermissionBulkCheckResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder permissionsBulkCheckRequestBuilder(String tenantId, BulkCheckBody body) throws ApiException {
    // verify the required parameter 'tenantId' is set
    if (tenantId == null) {
      throw new ApiException(400, "Missing the required parameter 'tenantId' when calling permissionsBulkCheck");
    }
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling permissionsBulkCheck");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/v1/tenants/{tenant_id}/permissions/bulk-check"
        .replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(body);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }
  /**
   * check api
   * 
   * @param tenantId Identifier of the tenant, if you are not using multi-tenancy (have only one tenant) use pre-inserted tenant &lt;code&gt;t1&lt;/code&gt; for this field. Required, and must match the pattern \\“[a-zA-Z0-9-,]+\\“, max 64 bytes. (required)
   * @param body  (required)
   * @return PermissionCheckResponse
   * @throws ApiException if fails to make API call
   */
  public PermissionCheckResponse permissionsCheck(String tenantId, CheckBody body) throws ApiException {
    ApiResponse<PermissionCheckResponse> localVarResponse = permissionsCheckWithHttpInfo(tenantId, body);
    return localVarResponse.getData();
  }

  /**
   * check api
   * 
   * @param tenantId Identifier of the tenant, if you are not using multi-tenancy (have only one tenant) use pre-inserted tenant &lt;code&gt;t1&lt;/code&gt; for this field. Required, and must match the pattern \\“[a-zA-Z0-9-,]+\\“, max 64 bytes. (required)
   * @param body  (required)
   * @return ApiResponse&lt;PermissionCheckResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<PermissionCheckResponse> permissionsCheckWithHttpInfo(String tenantId, CheckBody body) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = permissionsCheckRequestBuilder(tenantId, body);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("permissionsCheck", localVarResponse);
        }
        return new ApiResponse<PermissionCheckResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<PermissionCheckResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder permissionsCheckRequestBuilder(String tenantId, CheckBody body) throws ApiException {
    // verify the required parameter 'tenantId' is set
    if (tenantId == null) {
      throw new ApiException(400, "Missing the required parameter 'tenantId' when calling permissionsCheck");
    }
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling permissionsCheck");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/v1/tenants/{tenant_id}/permissions/check"
        .replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(body);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }
  /**
   * expand api
   * 
   * @param tenantId Identifier of the tenant, if you are not using multi-tenancy (have only one tenant) use pre-inserted tenant &lt;code&gt;t1&lt;/code&gt; for this field. Required, and must match the pattern \\“[a-zA-Z0-9-,]+\\“, max 64 bytes. (required)
   * @param body  (required)
   * @return PermissionExpandResponse
   * @throws ApiException if fails to make API call
   */
  public PermissionExpandResponse permissionsExpand(String tenantId, PermissionExpandBody body) throws ApiException {
    ApiResponse<PermissionExpandResponse> localVarResponse = permissionsExpandWithHttpInfo(tenantId, body);
    return localVarResponse.getData();
  }

  /**
   * expand api
   * 
   * @param tenantId Identifier of the tenant, if you are not using multi-tenancy (have only one tenant) use pre-inserted tenant &lt;code&gt;t1&lt;/code&gt; for this field. Required, and must match the pattern \\“[a-zA-Z0-9-,]+\\“, max 64 bytes. (required)
   * @param body  (required)
   * @return ApiResponse&lt;PermissionExpandResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<PermissionExpandResponse> permissionsExpandWithHttpInfo(String tenantId, PermissionExpandBody body) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = permissionsExpandRequestBuilder(tenantId, body);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("permissionsExpand", localVarResponse);
        }
        return new ApiResponse<PermissionExpandResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<PermissionExpandResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder permissionsExpandRequestBuilder(String tenantId, PermissionExpandBody body) throws ApiException {
    // verify the required parameter 'tenantId' is set
    if (tenantId == null) {
      throw new ApiException(400, "Missing the required parameter 'tenantId' when calling permissionsExpand");
    }
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling permissionsExpand");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/v1/tenants/{tenant_id}/permissions/expand"
        .replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(body);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }
  /**
   * lookup entity
   * 
   * @param tenantId Identifier of the tenant, if you are not using multi-tenancy (have only one tenant) use pre-inserted tenant &lt;code&gt;t1&lt;/code&gt; for this field. Required, and must match the pattern \\“[a-zA-Z0-9-,]+\\“, max 64 bytes. (required)
   * @param body  (required)
   * @return PermissionLookupEntityResponse
   * @throws ApiException if fails to make API call
   */
  public PermissionLookupEntityResponse permissionsLookupEntity(String tenantId, LookupEntityBody body) throws ApiException {
    ApiResponse<PermissionLookupEntityResponse> localVarResponse = permissionsLookupEntityWithHttpInfo(tenantId, body);
    return localVarResponse.getData();
  }

  /**
   * lookup entity
   * 
   * @param tenantId Identifier of the tenant, if you are not using multi-tenancy (have only one tenant) use pre-inserted tenant &lt;code&gt;t1&lt;/code&gt; for this field. Required, and must match the pattern \\“[a-zA-Z0-9-,]+\\“, max 64 bytes. (required)
   * @param body  (required)
   * @return ApiResponse&lt;PermissionLookupEntityResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<PermissionLookupEntityResponse> permissionsLookupEntityWithHttpInfo(String tenantId, LookupEntityBody body) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = permissionsLookupEntityRequestBuilder(tenantId, body);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("permissionsLookupEntity", localVarResponse);
        }
        return new ApiResponse<PermissionLookupEntityResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<PermissionLookupEntityResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder permissionsLookupEntityRequestBuilder(String tenantId, LookupEntityBody body) throws ApiException {
    // verify the required parameter 'tenantId' is set
    if (tenantId == null) {
      throw new ApiException(400, "Missing the required parameter 'tenantId' when calling permissionsLookupEntity");
    }
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling permissionsLookupEntity");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/v1/tenants/{tenant_id}/permissions/lookup-entity"
        .replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(body);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }
  /**
   * lookup entity stream
   * 
   * @param tenantId Identifier of the tenant, if you are not using multi-tenancy (have only one tenant) use pre-inserted tenant &lt;code&gt;t1&lt;/code&gt; for this field. Required, and must match the pattern \\“[a-zA-Z0-9-,]+\\“, max 64 bytes. (required)
   * @param body  (required)
   * @return StreamResultOfPermissionLookupEntityStreamResponse
   * @throws ApiException if fails to make API call
   */
  public StreamResultOfPermissionLookupEntityStreamResponse permissionsLookupEntityStream(String tenantId, LookupEntityStreamBody body) throws ApiException {
    ApiResponse<StreamResultOfPermissionLookupEntityStreamResponse> localVarResponse = permissionsLookupEntityStreamWithHttpInfo(tenantId, body);
    return localVarResponse.getData();
  }

  /**
   * lookup entity stream
   * 
   * @param tenantId Identifier of the tenant, if you are not using multi-tenancy (have only one tenant) use pre-inserted tenant &lt;code&gt;t1&lt;/code&gt; for this field. Required, and must match the pattern \\“[a-zA-Z0-9-,]+\\“, max 64 bytes. (required)
   * @param body  (required)
   * @return ApiResponse&lt;StreamResultOfPermissionLookupEntityStreamResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<StreamResultOfPermissionLookupEntityStreamResponse> permissionsLookupEntityStreamWithHttpInfo(String tenantId, LookupEntityStreamBody body) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = permissionsLookupEntityStreamRequestBuilder(tenantId, body);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("permissionsLookupEntityStream", localVarResponse);
        }
        return new ApiResponse<StreamResultOfPermissionLookupEntityStreamResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<StreamResultOfPermissionLookupEntityStreamResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder permissionsLookupEntityStreamRequestBuilder(String tenantId, LookupEntityStreamBody body) throws ApiException {
    // verify the required parameter 'tenantId' is set
    if (tenantId == null) {
      throw new ApiException(400, "Missing the required parameter 'tenantId' when calling permissionsLookupEntityStream");
    }
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling permissionsLookupEntityStream");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/v1/tenants/{tenant_id}/permissions/lookup-entity-stream"
        .replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(body);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }
  /**
   * lookup-subject
   * 
   * @param tenantId Identifier of the tenant, if you are not using multi-tenancy (have only one tenant) use pre-inserted tenant &lt;code&gt;t1&lt;/code&gt; for this field. Required, and must match the pattern \\“[a-zA-Z0-9-,]+\\“, max 64 bytes. (required)
   * @param body  (required)
   * @return PermissionLookupSubjectResponse
   * @throws ApiException if fails to make API call
   */
  public PermissionLookupSubjectResponse permissionsLookupSubject(String tenantId, LookupSubjectBody body) throws ApiException {
    ApiResponse<PermissionLookupSubjectResponse> localVarResponse = permissionsLookupSubjectWithHttpInfo(tenantId, body);
    return localVarResponse.getData();
  }

  /**
   * lookup-subject
   * 
   * @param tenantId Identifier of the tenant, if you are not using multi-tenancy (have only one tenant) use pre-inserted tenant &lt;code&gt;t1&lt;/code&gt; for this field. Required, and must match the pattern \\“[a-zA-Z0-9-,]+\\“, max 64 bytes. (required)
   * @param body  (required)
   * @return ApiResponse&lt;PermissionLookupSubjectResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<PermissionLookupSubjectResponse> permissionsLookupSubjectWithHttpInfo(String tenantId, LookupSubjectBody body) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = permissionsLookupSubjectRequestBuilder(tenantId, body);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("permissionsLookupSubject", localVarResponse);
        }
        return new ApiResponse<PermissionLookupSubjectResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<PermissionLookupSubjectResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder permissionsLookupSubjectRequestBuilder(String tenantId, LookupSubjectBody body) throws ApiException {
    // verify the required parameter 'tenantId' is set
    if (tenantId == null) {
      throw new ApiException(400, "Missing the required parameter 'tenantId' when calling permissionsLookupSubject");
    }
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling permissionsLookupSubject");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/v1/tenants/{tenant_id}/permissions/lookup-subject"
        .replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(body);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }
  /**
   * subject permission
   * 
   * @param tenantId Identifier of the tenant, if you are not using multi-tenancy (have only one tenant) use pre-inserted tenant &lt;code&gt;t1&lt;/code&gt; for this field. Required, and must match the pattern \\“[a-zA-Z0-9-,]+\\“, max 64 bytes. (required)
   * @param body  (required)
   * @return PermissionSubjectPermissionResponse
   * @throws ApiException if fails to make API call
   */
  public PermissionSubjectPermissionResponse permissionsSubjectPermission(String tenantId, SubjectPermissionBody body) throws ApiException {
    ApiResponse<PermissionSubjectPermissionResponse> localVarResponse = permissionsSubjectPermissionWithHttpInfo(tenantId, body);
    return localVarResponse.getData();
  }

  /**
   * subject permission
   * 
   * @param tenantId Identifier of the tenant, if you are not using multi-tenancy (have only one tenant) use pre-inserted tenant &lt;code&gt;t1&lt;/code&gt; for this field. Required, and must match the pattern \\“[a-zA-Z0-9-,]+\\“, max 64 bytes. (required)
   * @param body  (required)
   * @return ApiResponse&lt;PermissionSubjectPermissionResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<PermissionSubjectPermissionResponse> permissionsSubjectPermissionWithHttpInfo(String tenantId, SubjectPermissionBody body) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = permissionsSubjectPermissionRequestBuilder(tenantId, body);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("permissionsSubjectPermission", localVarResponse);
        }
        return new ApiResponse<PermissionSubjectPermissionResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<PermissionSubjectPermissionResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder permissionsSubjectPermissionRequestBuilder(String tenantId, SubjectPermissionBody body) throws ApiException {
    // verify the required parameter 'tenantId' is set
    if (tenantId == null) {
      throw new ApiException(400, "Missing the required parameter 'tenantId' when calling permissionsSubjectPermission");
    }
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling permissionsSubjectPermission");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/v1/tenants/{tenant_id}/permissions/subject-permission"
        .replace("{tenant_id}", ApiClient.urlEncode(tenantId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(body);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }
}
