/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.6.0
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.V1alpha1Type;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Application defined abstract type.
 */
@JsonPropertyOrder({
  AbstractType.JSON_PROPERTY_NAME,
  AbstractType.JSON_PROPERTY_PARAMETER_TYPES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class AbstractType {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PARAMETER_TYPES = "parameterTypes";
  private List<V1alpha1Type> parameterTypes;

  public AbstractType() { 
  }

  public AbstractType name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The fully qualified name of this abstract type.
   * @return name
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public AbstractType parameterTypes(List<V1alpha1Type> parameterTypes) {
    this.parameterTypes = parameterTypes;
    return this;
  }

  public AbstractType addParameterTypesItem(V1alpha1Type parameterTypesItem) {
    if (this.parameterTypes == null) {
      this.parameterTypes = new ArrayList<>();
    }
    this.parameterTypes.add(parameterTypesItem);
    return this;
  }

   /**
   * Parameter types for this abstract type.
   * @return parameterTypes
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARAMETER_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<V1alpha1Type> getParameterTypes() {
    return parameterTypes;
  }


  @JsonProperty(JSON_PROPERTY_PARAMETER_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParameterTypes(List<V1alpha1Type> parameterTypes) {
    this.parameterTypes = parameterTypes;
  }


  /**
   * Return true if this AbstractType object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AbstractType abstractType = (AbstractType) o;
    return Objects.equals(this.name, abstractType.name) &&
        Objects.equals(this.parameterTypes, abstractType.parameterTypes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, parameterTypes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AbstractType {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    parameterTypes: ").append(toIndentedString(parameterTypes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `name` to the URL query string
    if (getName() != null) {
      joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `parameterTypes` to the URL query string
    if (getParameterTypes() != null) {
      for (int i = 0; i < getParameterTypes().size(); i++) {
        if (getParameterTypes().get(i) != null) {
          joiner.add(getParameterTypes().get(i).toUrlQueryString(String.format("%sparameterTypes%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }
}

