/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.6.0
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Expr;
import co.permify.sdk.model.SourceInfo;
import co.permify.sdk.model.V1alpha1Reference;
import co.permify.sdk.model.V1alpha1Type;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * A CEL expression which has been successfully type checked.
 */
@JsonPropertyOrder({
  CheckedExpr.JSON_PROPERTY_REFERENCE_MAP,
  CheckedExpr.JSON_PROPERTY_TYPE_MAP,
  CheckedExpr.JSON_PROPERTY_SOURCE_INFO,
  CheckedExpr.JSON_PROPERTY_EXPR_VERSION,
  CheckedExpr.JSON_PROPERTY_EXPR
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class CheckedExpr {
  public static final String JSON_PROPERTY_REFERENCE_MAP = "referenceMap";
  private Map<String, V1alpha1Reference> referenceMap = new HashMap<>();

  public static final String JSON_PROPERTY_TYPE_MAP = "typeMap";
  private Map<String, V1alpha1Type> typeMap = new HashMap<>();

  public static final String JSON_PROPERTY_SOURCE_INFO = "sourceInfo";
  private SourceInfo sourceInfo;

  public static final String JSON_PROPERTY_EXPR_VERSION = "exprVersion";
  private String exprVersion;

  public static final String JSON_PROPERTY_EXPR = "expr";
  private Expr expr;

  public CheckedExpr() { 
  }

  public CheckedExpr referenceMap(Map<String, V1alpha1Reference> referenceMap) {
    this.referenceMap = referenceMap;
    return this;
  }

  public CheckedExpr putReferenceMapItem(String key, V1alpha1Reference referenceMapItem) {
    if (this.referenceMap == null) {
      this.referenceMap = new HashMap<>();
    }
    this.referenceMap.put(key, referenceMapItem);
    return this;
  }

   /**
   * A map from expression ids to resolved references.  The following entries are in this table:  - An Ident or Select expression is represented here if it resolves to a   declaration. For instance, if &#x60;a.b.c&#x60; is represented by   &#x60;select(select(id(a), b), c)&#x60;, and &#x60;a.b&#x60; resolves to a declaration,   while &#x60;c&#x60; is a field selection, then the reference is attached to the   nested select expression (but not to the id or or the outer select).   In turn, if &#x60;a&#x60; resolves to a declaration and &#x60;b.c&#x60; are field selections,   the reference is attached to the ident expression. - Every Call expression has an entry here, identifying the function being   called. - Every CreateStruct expression for a message has an entry, identifying   the message.
   * @return referenceMap
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REFERENCE_MAP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, V1alpha1Reference> getReferenceMap() {
    return referenceMap;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCE_MAP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReferenceMap(Map<String, V1alpha1Reference> referenceMap) {
    this.referenceMap = referenceMap;
  }


  public CheckedExpr typeMap(Map<String, V1alpha1Type> typeMap) {
    this.typeMap = typeMap;
    return this;
  }

  public CheckedExpr putTypeMapItem(String key, V1alpha1Type typeMapItem) {
    if (this.typeMap == null) {
      this.typeMap = new HashMap<>();
    }
    this.typeMap.put(key, typeMapItem);
    return this;
  }

   /**
   * A map from expression ids to types.  Every expression node which has a type different than DYN has a mapping here. If an expression has type DYN, it is omitted from this map to save space.
   * @return typeMap
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TYPE_MAP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, V1alpha1Type> getTypeMap() {
    return typeMap;
  }


  @JsonProperty(JSON_PROPERTY_TYPE_MAP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTypeMap(Map<String, V1alpha1Type> typeMap) {
    this.typeMap = typeMap;
  }


  public CheckedExpr sourceInfo(SourceInfo sourceInfo) {
    this.sourceInfo = sourceInfo;
    return this;
  }

   /**
   * Get sourceInfo
   * @return sourceInfo
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SOURCE_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SourceInfo getSourceInfo() {
    return sourceInfo;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceInfo(SourceInfo sourceInfo) {
    this.sourceInfo = sourceInfo;
  }


  public CheckedExpr exprVersion(String exprVersion) {
    this.exprVersion = exprVersion;
    return this;
  }

   /**
   * The expr version indicates the major / minor version number of the &#x60;expr&#x60; representation.  The most common reason for a version change will be to indicate to the CEL runtimes that transformations have been performed on the expr during static analysis. In some cases, this will save the runtime the work of applying the same or similar transformations prior to evaluation.
   * @return exprVersion
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXPR_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExprVersion() {
    return exprVersion;
  }


  @JsonProperty(JSON_PROPERTY_EXPR_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExprVersion(String exprVersion) {
    this.exprVersion = exprVersion;
  }


  public CheckedExpr expr(Expr expr) {
    this.expr = expr;
    return this;
  }

   /**
   * Get expr
   * @return expr
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXPR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Expr getExpr() {
    return expr;
  }


  @JsonProperty(JSON_PROPERTY_EXPR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpr(Expr expr) {
    this.expr = expr;
  }


  /**
   * Return true if this CheckedExpr object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CheckedExpr checkedExpr = (CheckedExpr) o;
    return Objects.equals(this.referenceMap, checkedExpr.referenceMap) &&
        Objects.equals(this.typeMap, checkedExpr.typeMap) &&
        Objects.equals(this.sourceInfo, checkedExpr.sourceInfo) &&
        Objects.equals(this.exprVersion, checkedExpr.exprVersion) &&
        Objects.equals(this.expr, checkedExpr.expr);
  }

  @Override
  public int hashCode() {
    return Objects.hash(referenceMap, typeMap, sourceInfo, exprVersion, expr);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CheckedExpr {\n");
    sb.append("    referenceMap: ").append(toIndentedString(referenceMap)).append("\n");
    sb.append("    typeMap: ").append(toIndentedString(typeMap)).append("\n");
    sb.append("    sourceInfo: ").append(toIndentedString(sourceInfo)).append("\n");
    sb.append("    exprVersion: ").append(toIndentedString(exprVersion)).append("\n");
    sb.append("    expr: ").append(toIndentedString(expr)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `referenceMap` to the URL query string
    if (getReferenceMap() != null) {
      for (String _key : getReferenceMap().keySet()) {
        if (getReferenceMap().get(_key) != null) {
          joiner.add(getReferenceMap().get(_key).toUrlQueryString(String.format("%sreferenceMap%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `typeMap` to the URL query string
    if (getTypeMap() != null) {
      for (String _key : getTypeMap().keySet()) {
        if (getTypeMap().get(_key) != null) {
          joiner.add(getTypeMap().get(_key).toUrlQueryString(String.format("%stypeMap%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `sourceInfo` to the URL query string
    if (getSourceInfo() != null) {
      joiner.add(getSourceInfo().toUrlQueryString(prefix + "sourceInfo" + suffix));
    }

    // add `exprVersion` to the URL query string
    if (getExprVersion() != null) {
      joiner.add(String.format("%sexprVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExprVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `expr` to the URL query string
    if (getExpr() != null) {
      joiner.add(getExpr().toUrlQueryString(prefix + "expr" + suffix));
    }

    return joiner.toString();
  }
}

