/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.6.0
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * CEL component specifier.   - COMPONENT_UNSPECIFIED: Unspecified, default.  - COMPONENT_PARSER: Parser. Converts a CEL string to an AST.  - COMPONENT_TYPE_CHECKER: Type checker. Checks that references in an AST are defined and types agree.  - COMPONENT_RUNTIME: Runtime. Evaluates a parsed and optionally checked CEL AST against a context.
 */
public enum Component {
  
  UNSPECIFIED("COMPONENT_UNSPECIFIED"),
  
  PARSER("COMPONENT_PARSER"),
  
  TYPE_CHECKER("COMPONENT_TYPE_CHECKER"),
  
  RUNTIME("COMPONENT_RUNTIME");

  private String value;

  Component(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static Component fromValue(String value) {
    for (Component b : Component.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    if (prefix == null) {
      prefix = "";
    }

    return String.format("%s=%s", prefix, this.toString());
  }

}

