/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.6.0
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Expr;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * A comprehension expression applied to a list or map.  Comprehensions are not part of the core syntax, but enabled with macros. A macro matches a specific call signature within a parsed AST and replaces the call with an alternate AST block. Macro expansion happens at parse time.  The following macros are supported within CEL:  Aggregate type macros may be applied to all elements in a list or all keys in a map:  *  &#x60;all&#x60;, &#x60;exists&#x60;, &#x60;exists_one&#x60; -  test a predicate expression against    the inputs and return &#x60;true&#x60; if the predicate is satisfied for all,    any, or only one value &#x60;list.all(x, x &lt; 10)&#x60;. *  &#x60;filter&#x60; - test a predicate expression against the inputs and return    the subset of elements which satisfy the predicate:    &#x60;payments.filter(p, p &gt; 1000)&#x60;. *  &#x60;map&#x60; - apply an expression to all elements in the input and return the    output aggregate type: &#x60;[1, 2, 3].map(i, i * i)&#x60;.  The &#x60;has(m.x)&#x60; macro tests whether the property &#x60;x&#x60; is present in struct &#x60;m&#x60;. The semantics of this macro depend on the type of &#x60;m&#x60;. For proto2 messages &#x60;has(m.x)&#x60; is defined as &#39;defined, but not set&#x60;. For proto3, the macro tests whether the property is set to its default. For map and struct types, the macro tests whether the property &#x60;x&#x60; is defined on &#x60;m&#x60;.  Comprehensions for the standard environment macros evaluation can be best visualized as the following pseudocode:  &#x60;&#x60;&#x60; let &#x60;accu_var&#x60; &#x3D; &#x60;accu_init&#x60; for (let &#x60;iter_var&#x60; in &#x60;iter_range&#x60;) {   if (!&#x60;loop_condition&#x60;) {     break   }   &#x60;accu_var&#x60; &#x3D; &#x60;loop_step&#x60; } return &#x60;result&#x60; &#x60;&#x60;&#x60;  Comprehensions for the optional V2 macros which support map-to-map translation differ slightly from the standard environment macros in that they expose both the key or index in addition to the value for each list or map entry:  &#x60;&#x60;&#x60; let &#x60;accu_var&#x60; &#x3D; &#x60;accu_init&#x60; for (let &#x60;iter_var&#x60;, &#x60;iter_var2&#x60; in &#x60;iter_range&#x60;) {   if (!&#x60;loop_condition&#x60;) {     break   }   &#x60;accu_var&#x60; &#x3D; &#x60;loop_step&#x60; } return &#x60;result&#x60; &#x60;&#x60;&#x60;
 */
@JsonPropertyOrder({
  Comprehension.JSON_PROPERTY_ITER_VAR,
  Comprehension.JSON_PROPERTY_ITER_VAR2,
  Comprehension.JSON_PROPERTY_ITER_RANGE,
  Comprehension.JSON_PROPERTY_ACCU_VAR,
  Comprehension.JSON_PROPERTY_ACCU_INIT,
  Comprehension.JSON_PROPERTY_LOOP_CONDITION,
  Comprehension.JSON_PROPERTY_LOOP_STEP,
  Comprehension.JSON_PROPERTY_RESULT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class Comprehension {
  public static final String JSON_PROPERTY_ITER_VAR = "iterVar";
  private String iterVar;

  public static final String JSON_PROPERTY_ITER_VAR2 = "iterVar2";
  private String iterVar2;

  public static final String JSON_PROPERTY_ITER_RANGE = "iterRange";
  private Expr iterRange;

  public static final String JSON_PROPERTY_ACCU_VAR = "accuVar";
  private String accuVar;

  public static final String JSON_PROPERTY_ACCU_INIT = "accuInit";
  private Expr accuInit;

  public static final String JSON_PROPERTY_LOOP_CONDITION = "loopCondition";
  private Expr loopCondition;

  public static final String JSON_PROPERTY_LOOP_STEP = "loopStep";
  private Expr loopStep;

  public static final String JSON_PROPERTY_RESULT = "result";
  private Expr result;

  public Comprehension() { 
  }

  public Comprehension iterVar(String iterVar) {
    this.iterVar = iterVar;
    return this;
  }

   /**
   * The name of the first iteration variable. When the iter_range is a list, this variable is the list element. When the iter_range is a map, this variable is the map entry key.
   * @return iterVar
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ITER_VAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIterVar() {
    return iterVar;
  }


  @JsonProperty(JSON_PROPERTY_ITER_VAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIterVar(String iterVar) {
    this.iterVar = iterVar;
  }


  public Comprehension iterVar2(String iterVar2) {
    this.iterVar2 = iterVar2;
    return this;
  }

   /**
   * The name of the second iteration variable, empty if not set. When the iter_range is a list, this variable is the integer index. When the iter_range is a map, this variable is the map entry value. This field is only set for comprehension v2 macros.
   * @return iterVar2
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ITER_VAR2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIterVar2() {
    return iterVar2;
  }


  @JsonProperty(JSON_PROPERTY_ITER_VAR2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIterVar2(String iterVar2) {
    this.iterVar2 = iterVar2;
  }


  public Comprehension iterRange(Expr iterRange) {
    this.iterRange = iterRange;
    return this;
  }

   /**
   * Get iterRange
   * @return iterRange
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ITER_RANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Expr getIterRange() {
    return iterRange;
  }


  @JsonProperty(JSON_PROPERTY_ITER_RANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIterRange(Expr iterRange) {
    this.iterRange = iterRange;
  }


  public Comprehension accuVar(String accuVar) {
    this.accuVar = accuVar;
    return this;
  }

   /**
   * The name of the variable used for accumulation of the result.
   * @return accuVar
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACCU_VAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccuVar() {
    return accuVar;
  }


  @JsonProperty(JSON_PROPERTY_ACCU_VAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccuVar(String accuVar) {
    this.accuVar = accuVar;
  }


  public Comprehension accuInit(Expr accuInit) {
    this.accuInit = accuInit;
    return this;
  }

   /**
   * Get accuInit
   * @return accuInit
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACCU_INIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Expr getAccuInit() {
    return accuInit;
  }


  @JsonProperty(JSON_PROPERTY_ACCU_INIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccuInit(Expr accuInit) {
    this.accuInit = accuInit;
  }


  public Comprehension loopCondition(Expr loopCondition) {
    this.loopCondition = loopCondition;
    return this;
  }

   /**
   * Get loopCondition
   * @return loopCondition
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOOP_CONDITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Expr getLoopCondition() {
    return loopCondition;
  }


  @JsonProperty(JSON_PROPERTY_LOOP_CONDITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoopCondition(Expr loopCondition) {
    this.loopCondition = loopCondition;
  }


  public Comprehension loopStep(Expr loopStep) {
    this.loopStep = loopStep;
    return this;
  }

   /**
   * Get loopStep
   * @return loopStep
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOOP_STEP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Expr getLoopStep() {
    return loopStep;
  }


  @JsonProperty(JSON_PROPERTY_LOOP_STEP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoopStep(Expr loopStep) {
    this.loopStep = loopStep;
  }


  public Comprehension result(Expr result) {
    this.result = result;
    return this;
  }

   /**
   * Get result
   * @return result
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Expr getResult() {
    return result;
  }


  @JsonProperty(JSON_PROPERTY_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResult(Expr result) {
    this.result = result;
  }


  /**
   * Return true if this Comprehension object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Comprehension comprehension = (Comprehension) o;
    return Objects.equals(this.iterVar, comprehension.iterVar) &&
        Objects.equals(this.iterVar2, comprehension.iterVar2) &&
        Objects.equals(this.iterRange, comprehension.iterRange) &&
        Objects.equals(this.accuVar, comprehension.accuVar) &&
        Objects.equals(this.accuInit, comprehension.accuInit) &&
        Objects.equals(this.loopCondition, comprehension.loopCondition) &&
        Objects.equals(this.loopStep, comprehension.loopStep) &&
        Objects.equals(this.result, comprehension.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(iterVar, iterVar2, iterRange, accuVar, accuInit, loopCondition, loopStep, result);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Comprehension {\n");
    sb.append("    iterVar: ").append(toIndentedString(iterVar)).append("\n");
    sb.append("    iterVar2: ").append(toIndentedString(iterVar2)).append("\n");
    sb.append("    iterRange: ").append(toIndentedString(iterRange)).append("\n");
    sb.append("    accuVar: ").append(toIndentedString(accuVar)).append("\n");
    sb.append("    accuInit: ").append(toIndentedString(accuInit)).append("\n");
    sb.append("    loopCondition: ").append(toIndentedString(loopCondition)).append("\n");
    sb.append("    loopStep: ").append(toIndentedString(loopStep)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `iterVar` to the URL query string
    if (getIterVar() != null) {
      joiner.add(String.format("%siterVar%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIterVar()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `iterVar2` to the URL query string
    if (getIterVar2() != null) {
      joiner.add(String.format("%siterVar2%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIterVar2()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `iterRange` to the URL query string
    if (getIterRange() != null) {
      joiner.add(getIterRange().toUrlQueryString(prefix + "iterRange" + suffix));
    }

    // add `accuVar` to the URL query string
    if (getAccuVar() != null) {
      joiner.add(String.format("%saccuVar%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAccuVar()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `accuInit` to the URL query string
    if (getAccuInit() != null) {
      joiner.add(getAccuInit().toUrlQueryString(prefix + "accuInit" + suffix));
    }

    // add `loopCondition` to the URL query string
    if (getLoopCondition() != null) {
      joiner.add(getLoopCondition().toUrlQueryString(prefix + "loopCondition" + suffix));
    }

    // add `loopStep` to the URL query string
    if (getLoopStep() != null) {
      joiner.add(getLoopStep().toUrlQueryString(prefix + "loopStep" + suffix));
    }

    // add `result` to the URL query string
    if (getResult() != null) {
      joiner.add(getResult().toUrlQueryString(prefix + "result" + suffix));
    }

    return joiner.toString();
  }
}

