/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.6.0
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Any;
import co.permify.sdk.model.Subjects;
import co.permify.sdk.model.Values;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * ExpandLeaf is the leaf node of an Expand tree and can be either a set of Subjects or a set of Values.
 */
@JsonPropertyOrder({
  ExpandLeaf.JSON_PROPERTY_SUBJECTS,
  ExpandLeaf.JSON_PROPERTY_VALUES,
  ExpandLeaf.JSON_PROPERTY_VALUE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ExpandLeaf {
  public static final String JSON_PROPERTY_SUBJECTS = "subjects";
  private Subjects subjects;

  public static final String JSON_PROPERTY_VALUES = "values";
  private Values values;

  public static final String JSON_PROPERTY_VALUE = "value";
  private Any value;

  public ExpandLeaf() { 
  }

  public ExpandLeaf subjects(Subjects subjects) {
    this.subjects = subjects;
    return this;
  }

   /**
   * Get subjects
   * @return subjects
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Subjects getSubjects() {
    return subjects;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubjects(Subjects subjects) {
    this.subjects = subjects;
  }


  public ExpandLeaf values(Values values) {
    this.values = values;
    return this;
  }

   /**
   * Get values
   * @return values
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Values getValues() {
    return values;
  }


  @JsonProperty(JSON_PROPERTY_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValues(Values values) {
    this.values = values;
  }


  public ExpandLeaf value(Any value) {
    this.value = value;
    return this;
  }

   /**
   * Get value
   * @return value
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Any getValue() {
    return value;
  }


  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(Any value) {
    this.value = value;
  }


  /**
   * Return true if this ExpandLeaf object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExpandLeaf expandLeaf = (ExpandLeaf) o;
    return Objects.equals(this.subjects, expandLeaf.subjects) &&
        Objects.equals(this.values, expandLeaf.values) &&
        Objects.equals(this.value, expandLeaf.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(subjects, values, value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExpandLeaf {\n");
    sb.append("    subjects: ").append(toIndentedString(subjects)).append("\n");
    sb.append("    values: ").append(toIndentedString(values)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `subjects` to the URL query string
    if (getSubjects() != null) {
      joiner.add(getSubjects().toUrlQueryString(prefix + "subjects" + suffix));
    }

    // add `values` to the URL query string
    if (getValues() != null) {
      joiner.add(getValues().toUrlQueryString(prefix + "values" + suffix));
    }

    // add `value` to the URL query string
    if (getValue() != null) {
      joiner.add(String.format("%svalue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getValue()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

