/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.6.0
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * PermissionLookupSubjectRequestMetadata metadata for the PermissionLookupSubjectRequest.
 */
@JsonPropertyOrder({
  PermissionLookupSubjectRequestMetadata.JSON_PROPERTY_SCHEMA_VERSION,
  PermissionLookupSubjectRequestMetadata.JSON_PROPERTY_SNAP_TOKEN,
  PermissionLookupSubjectRequestMetadata.JSON_PROPERTY_DEPTH
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class PermissionLookupSubjectRequestMetadata {
  public static final String JSON_PROPERTY_SCHEMA_VERSION = "schema_version";
  private String schemaVersion;

  public static final String JSON_PROPERTY_SNAP_TOKEN = "snap_token";
  private String snapToken;

  public static final String JSON_PROPERTY_DEPTH = "depth";
  private Integer depth;

  public PermissionLookupSubjectRequestMetadata() { 
  }

  public PermissionLookupSubjectRequestMetadata schemaVersion(String schemaVersion) {
    this.schemaVersion = schemaVersion;
    return this;
  }

   /**
   * Version of the schema.
   * @return schemaVersion
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SCHEMA_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSchemaVersion() {
    return schemaVersion;
  }


  @JsonProperty(JSON_PROPERTY_SCHEMA_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSchemaVersion(String schemaVersion) {
    this.schemaVersion = schemaVersion;
  }


  public PermissionLookupSubjectRequestMetadata snapToken(String snapToken) {
    this.snapToken = snapToken;
    return this;
  }

   /**
   * The snap token to avoid stale cache, see more details on [Snap Tokens](../../operations/snap-tokens).
   * @return snapToken
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SNAP_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSnapToken() {
    return snapToken;
  }


  @JsonProperty(JSON_PROPERTY_SNAP_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSnapToken(String snapToken) {
    this.snapToken = snapToken;
  }


  public PermissionLookupSubjectRequestMetadata depth(Integer depth) {
    this.depth = depth;
    return this;
  }

   /**
   * Query limit when if recursive database queries got in loop.
   * @return depth
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEPTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDepth() {
    return depth;
  }


  @JsonProperty(JSON_PROPERTY_DEPTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDepth(Integer depth) {
    this.depth = depth;
  }


  /**
   * Return true if this PermissionLookupSubjectRequestMetadata object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PermissionLookupSubjectRequestMetadata permissionLookupSubjectRequestMetadata = (PermissionLookupSubjectRequestMetadata) o;
    return Objects.equals(this.schemaVersion, permissionLookupSubjectRequestMetadata.schemaVersion) &&
        Objects.equals(this.snapToken, permissionLookupSubjectRequestMetadata.snapToken) &&
        Objects.equals(this.depth, permissionLookupSubjectRequestMetadata.depth);
  }

  @Override
  public int hashCode() {
    return Objects.hash(schemaVersion, snapToken, depth);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PermissionLookupSubjectRequestMetadata {\n");
    sb.append("    schemaVersion: ").append(toIndentedString(schemaVersion)).append("\n");
    sb.append("    snapToken: ").append(toIndentedString(snapToken)).append("\n");
    sb.append("    depth: ").append(toIndentedString(depth)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `schema_version` to the URL query string
    if (getSchemaVersion() != null) {
      joiner.add(String.format("%sschema_version%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSchemaVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `snap_token` to the URL query string
    if (getSnapToken() != null) {
      joiner.add(String.format("%ssnap_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSnapToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `depth` to the URL query string
    if (getDepth() != null) {
      joiner.add(String.format("%sdepth%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDepth()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

