/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.6.0
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * SchemaListRequest is the request message for the List method in the Schema service. It contains tenant_id for which the schemas are to be listed.
 */
@JsonPropertyOrder({
  SchemaListBody.JSON_PROPERTY_PAGE_SIZE,
  SchemaListBody.JSON_PROPERTY_CONTINUOUS_TOKEN
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class SchemaListBody {
  public static final String JSON_PROPERTY_PAGE_SIZE = "page_size";
  private Long pageSize;

  public static final String JSON_PROPERTY_CONTINUOUS_TOKEN = "continuous_token";
  private String continuousToken;

  public SchemaListBody() { 
  }

  public SchemaListBody pageSize(Long pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * page_size is the number of schemas to be returned in the response. The value should be between 1 and 100.
   * @return pageSize
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPageSize() {
    return pageSize;
  }


  @JsonProperty(JSON_PROPERTY_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }


  public SchemaListBody continuousToken(String continuousToken) {
    this.continuousToken = continuousToken;
    return this;
  }

   /**
   * continuous_token is an optional parameter used for pagination. It should be the value received in the previous response.
   * @return continuousToken
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTINUOUS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinuousToken() {
    return continuousToken;
  }


  @JsonProperty(JSON_PROPERTY_CONTINUOUS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinuousToken(String continuousToken) {
    this.continuousToken = continuousToken;
  }


  /**
   * Return true if this Schema.ListBody object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SchemaListBody schemaListBody = (SchemaListBody) o;
    return Objects.equals(this.pageSize, schemaListBody.pageSize) &&
        Objects.equals(this.continuousToken, schemaListBody.continuousToken);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageSize, continuousToken);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SchemaListBody {\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    continuousToken: ").append(toIndentedString(continuousToken)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `page_size` to the URL query string
    if (getPageSize() != null) {
      joiner.add(String.format("%spage_size%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPageSize()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `continuous_token` to the URL query string
    if (getContinuousToken() != null) {
      joiner.add(String.format("%scontinuous_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContinuousToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

