/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.6.0
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Version
 */
@JsonPropertyOrder({
  Version.JSON_PROPERTY_MAJOR,
  Version.JSON_PROPERTY_MINOR
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class Version {
  public static final String JSON_PROPERTY_MAJOR = "major";
  private String major;

  public static final String JSON_PROPERTY_MINOR = "minor";
  private String minor;

  public Version() { 
  }

  public Version major(String major) {
    this.major = major;
    return this;
  }

   /**
   * Major version changes indicate different required support level from the required components.
   * @return major
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MAJOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMajor() {
    return major;
  }


  @JsonProperty(JSON_PROPERTY_MAJOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMajor(String major) {
    this.major = major;
  }


  public Version minor(String minor) {
    this.minor = minor;
    return this;
  }

   /**
   * Minor version changes must not change the observed behavior from existing implementations, but may be provided informationally.
   * @return minor
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MINOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinor() {
    return minor;
  }


  @JsonProperty(JSON_PROPERTY_MINOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinor(String minor) {
    this.minor = minor;
  }


  /**
   * Return true if this Version object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Version version = (Version) o;
    return Objects.equals(this.major, version.major) &&
        Objects.equals(this.minor, version.minor);
  }

  @Override
  public int hashCode() {
    return Objects.hash(major, minor);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Version {\n");
    sb.append("    major: ").append(toIndentedString(major)).append("\n");
    sb.append("    minor: ").append(toIndentedString(minor)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `major` to the URL query string
    if (getMajor() != null) {
      joiner.add(String.format("%smajor%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMajor()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `minor` to the URL query string
    if (getMinor() != null) {
      joiner.add(String.format("%sminor%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMinor()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

