/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.model.Argument;
import co.permify.sdk.model.Context;
import co.permify.sdk.model.PermissionBulkCheckRequestItem;
import co.permify.sdk.model.PermissionCheckRequestMetadata;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"metadata", "items", "context", "arguments"})
public class BulkCheckBody {
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private PermissionCheckRequestMetadata metadata;
    public static final String JSON_PROPERTY_ITEMS = "items";
    private List<PermissionBulkCheckRequestItem> items;
    public static final String JSON_PROPERTY_CONTEXT = "context";
    private Context context;
    public static final String JSON_PROPERTY_ARGUMENTS = "arguments";
    private List<Argument> arguments;

    public BulkCheckBody metadata(PermissionCheckRequestMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PermissionCheckRequestMetadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(PermissionCheckRequestMetadata metadata) {
        this.metadata = metadata;
    }

    public BulkCheckBody items(List<PermissionBulkCheckRequestItem> items) {
        this.items = items;
        return this;
    }

    public BulkCheckBody addItemsItem(PermissionBulkCheckRequestItem itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<PermissionBulkCheckRequestItem>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PermissionBulkCheckRequestItem> getItems() {
        return this.items;
    }

    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setItems(List<PermissionBulkCheckRequestItem> items) {
        this.items = items;
    }

    public BulkCheckBody context(Context context) {
        this.context = context;
        return this;
    }

    @Nullable
    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Context getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContext(Context context) {
        this.context = context;
    }

    public BulkCheckBody arguments(List<Argument> arguments) {
        this.arguments = arguments;
        return this;
    }

    public BulkCheckBody addArgumentsItem(Argument argumentsItem) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<Argument>();
        }
        this.arguments.add(argumentsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="arguments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @JsonProperty(value="arguments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArguments(List<Argument> arguments) {
        this.arguments = arguments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkCheckBody bulkCheckBody = (BulkCheckBody)o;
        return Objects.equals(this.metadata, bulkCheckBody.metadata) && Objects.equals(this.items, bulkCheckBody.items) && Objects.equals(this.context, bulkCheckBody.context) && Objects.equals(this.arguments, bulkCheckBody.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.items, this.context, this.arguments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkCheckBody {\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getMetadata() != null) {
            joiner.add(this.getMetadata().toUrlQueryString((String)prefix + JSON_PROPERTY_METADATA + suffix));
        }
        if (this.getItems() != null) {
            for (i = 0; i < this.getItems().size(); ++i) {
                if (this.getItems().get(i) == null) continue;
                joiner.add(this.getItems().get(i).toUrlQueryString(String.format("%sitems%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getContext() != null) {
            joiner.add(this.getContext().toUrlQueryString((String)prefix + JSON_PROPERTY_CONTEXT + suffix));
        }
        if (this.getArguments() != null) {
            for (i = 0; i < this.getArguments().size(); ++i) {
                if (this.getArguments().get(i) == null) continue;
                joiner.add(this.getArguments().get(i).toUrlQueryString(String.format("%sarguments%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

