/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum Component {
    UNSPECIFIED("COMPONENT_UNSPECIFIED"),
    PARSER("COMPONENT_PARSER"),
    TYPE_CHECKER("COMPONENT_TYPE_CHECKER"),
    RUNTIME("COMPONENT_RUNTIME");

    private String value;

    private Component(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static Component fromValue(String value) {
        for (Component b : Component.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

