/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.model.Attribute;
import co.permify.sdk.model.DataChangeOperation;
import co.permify.sdk.model.Tuple;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"operation", "tuple", "attribute"})
public class DataChange {
    public static final String JSON_PROPERTY_OPERATION = "operation";
    private DataChangeOperation operation = DataChangeOperation.UNSPECIFIED;
    public static final String JSON_PROPERTY_TUPLE = "tuple";
    private Tuple tuple;
    public static final String JSON_PROPERTY_ATTRIBUTE = "attribute";
    private Attribute attribute;

    public DataChange operation(DataChangeOperation operation) {
        this.operation = operation;
        return this;
    }

    @Nullable
    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DataChangeOperation getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperation(DataChangeOperation operation) {
        this.operation = operation;
    }

    public DataChange tuple(Tuple tuple) {
        this.tuple = tuple;
        return this;
    }

    @Nullable
    @JsonProperty(value="tuple")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Tuple getTuple() {
        return this.tuple;
    }

    @JsonProperty(value="tuple")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTuple(Tuple tuple) {
        this.tuple = tuple;
    }

    public DataChange attribute(Attribute attribute) {
        this.attribute = attribute;
        return this;
    }

    @Nullable
    @JsonProperty(value="attribute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Attribute getAttribute() {
        return this.attribute;
    }

    @JsonProperty(value="attribute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataChange dataChange = (DataChange)o;
        return Objects.equals((Object)this.operation, (Object)dataChange.operation) && Objects.equals(this.tuple, dataChange.tuple) && Objects.equals(this.attribute, dataChange.attribute);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.tuple, this.attribute});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataChange {\n");
        sb.append("    operation: ").append(this.toIndentedString((Object)this.operation)).append("\n");
        sb.append("    tuple: ").append(this.toIndentedString(this.tuple)).append("\n");
        sb.append("    attribute: ").append(this.toIndentedString(this.attribute)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getOperation() != null) {
            joiner.add(String.format("%soperation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getOperation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTuple() != null) {
            joiner.add(this.getTuple().toUrlQueryString((String)prefix + JSON_PROPERTY_TUPLE + suffix));
        }
        if (this.getAttribute() != null) {
            joiner.add(this.getAttribute().toUrlQueryString((String)prefix + JSON_PROPERTY_ATTRIBUTE + suffix));
        }
        return joiner.toString();
    }
}

