/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.model.ExpandTreeNodeOperation;
import co.permify.sdk.model.V1Expand;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"operation", "children"})
public class ExpandTreeNode {
    public static final String JSON_PROPERTY_OPERATION = "operation";
    private ExpandTreeNodeOperation operation = ExpandTreeNodeOperation.UNSPECIFIED;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    private List<V1Expand> children;

    public ExpandTreeNode operation(ExpandTreeNodeOperation operation) {
        this.operation = operation;
        return this;
    }

    @Nullable
    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExpandTreeNodeOperation getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperation(ExpandTreeNodeOperation operation) {
        this.operation = operation;
    }

    public ExpandTreeNode children(List<V1Expand> children) {
        this.children = children;
        return this;
    }

    public ExpandTreeNode addChildrenItem(V1Expand childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<V1Expand>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<V1Expand> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(List<V1Expand> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpandTreeNode expandTreeNode = (ExpandTreeNode)o;
        return Objects.equals((Object)this.operation, (Object)expandTreeNode.operation) && Objects.equals(this.children, expandTreeNode.children);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.children});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExpandTreeNode {\n");
        sb.append("    operation: ").append(this.toIndentedString((Object)this.operation)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getOperation() != null) {
            joiner.add(String.format("%soperation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getOperation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getChildren() != null) {
            for (int i = 0; i < this.getChildren().size(); ++i) {
                if (this.getChildren().get(i) == null) continue;
                joiner.add(this.getChildren().get(i).toUrlQueryString(String.format("%schildren%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

