/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.6.1
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Attribute;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * AttributeReadResponse defines the structure of the response to an attribute read request. It includes the attributes retrieved and a continuous token for handling result pagination.
 */
@JsonPropertyOrder({
  AttributeReadResponse.JSON_PROPERTY_ATTRIBUTES,
  AttributeReadResponse.JSON_PROPERTY_CONTINUOUS_TOKEN
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class AttributeReadResponse {
  public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
  private List<Attribute> attributes;

  public static final String JSON_PROPERTY_CONTINUOUS_TOKEN = "continuous_token";
  private String continuousToken;

  public AttributeReadResponse() { 
  }

  public AttributeReadResponse attributes(List<Attribute> attributes) {
    this.attributes = attributes;
    return this;
  }

  public AttributeReadResponse addAttributesItem(Attribute attributesItem) {
    if (this.attributes == null) {
      this.attributes = new ArrayList<>();
    }
    this.attributes.add(attributesItem);
    return this;
  }

   /**
   * attributes is a list of the attributes retrieved in the read operation.
   * @return attributes
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Attribute> getAttributes() {
    return attributes;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributes(List<Attribute> attributes) {
    this.attributes = attributes;
  }


  public AttributeReadResponse continuousToken(String continuousToken) {
    this.continuousToken = continuousToken;
    return this;
  }

   /**
   * continuous_token is used in the case of paginated reads to retrieve the next page of results.
   * @return continuousToken
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTINUOUS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinuousToken() {
    return continuousToken;
  }


  @JsonProperty(JSON_PROPERTY_CONTINUOUS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinuousToken(String continuousToken) {
    this.continuousToken = continuousToken;
  }


  /**
   * Return true if this AttributeReadResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AttributeReadResponse attributeReadResponse = (AttributeReadResponse) o;
    return Objects.equals(this.attributes, attributeReadResponse.attributes) &&
        Objects.equals(this.continuousToken, attributeReadResponse.continuousToken);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributes, continuousToken);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AttributeReadResponse {\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    continuousToken: ").append(toIndentedString(continuousToken)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `attributes` to the URL query string
    if (getAttributes() != null) {
      for (int i = 0; i < getAttributes().size(); i++) {
        if (getAttributes().get(i) != null) {
          joiner.add(getAttributes().get(i).toUrlQueryString(String.format("%sattributes%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `continuous_token` to the URL query string
    if (getContinuousToken() != null) {
      joiner.add(String.format("%scontinuous_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContinuousToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

