/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.6.1
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.DataBundle;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * BundleWriteRequest is used to request the writing of a bundle. It contains the tenant_id to identify the tenant and the Bundles object.
 */
@JsonPropertyOrder({
  BundleWriteBody.JSON_PROPERTY_BUNDLES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class BundleWriteBody {
  public static final String JSON_PROPERTY_BUNDLES = "bundles";
  private List<DataBundle> bundles;

  public BundleWriteBody() { 
  }

  public BundleWriteBody bundles(List<DataBundle> bundles) {
    this.bundles = bundles;
    return this;
  }

  public BundleWriteBody addBundlesItem(DataBundle bundlesItem) {
    if (this.bundles == null) {
      this.bundles = new ArrayList<>();
    }
    this.bundles.add(bundlesItem);
    return this;
  }

   /**
   * Contains the bundle data to be written.
   * @return bundles
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BUNDLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DataBundle> getBundles() {
    return bundles;
  }


  @JsonProperty(JSON_PROPERTY_BUNDLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBundles(List<DataBundle> bundles) {
    this.bundles = bundles;
  }


  /**
   * Return true if this Bundle.WriteBody object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BundleWriteBody bundleWriteBody = (BundleWriteBody) o;
    return Objects.equals(this.bundles, bundleWriteBody.bundles);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bundles);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BundleWriteBody {\n");
    sb.append("    bundles: ").append(toIndentedString(bundles)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `bundles` to the URL query string
    if (getBundles() != null) {
      for (int i = 0; i < getBundles().size(); i++) {
        if (getBundles().get(i) != null) {
          joiner.add(getBundles().get(i).toUrlQueryString(String.format("%sbundles%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }
}

