/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.6.1
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Attribute;
import co.permify.sdk.model.Tuple;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Context encapsulates the information related to a single operation, including the tuples involved and the associated attributes.
 */
@JsonPropertyOrder({
  Context.JSON_PROPERTY_TUPLES,
  Context.JSON_PROPERTY_ATTRIBUTES,
  Context.JSON_PROPERTY_DATA
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class Context {
  public static final String JSON_PROPERTY_TUPLES = "tuples";
  private List<Tuple> tuples;

  public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
  private List<Attribute> attributes;

  public static final String JSON_PROPERTY_DATA = "data";
  private Object data;

  public Context() { 
  }

  public Context tuples(List<Tuple> tuples) {
    this.tuples = tuples;
    return this;
  }

  public Context addTuplesItem(Tuple tuplesItem) {
    if (this.tuples == null) {
      this.tuples = new ArrayList<>();
    }
    this.tuples.add(tuplesItem);
    return this;
  }

   /**
   * A repeated field of tuples involved in the operation.
   * @return tuples
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TUPLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Tuple> getTuples() {
    return tuples;
  }


  @JsonProperty(JSON_PROPERTY_TUPLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTuples(List<Tuple> tuples) {
    this.tuples = tuples;
  }


  public Context attributes(List<Attribute> attributes) {
    this.attributes = attributes;
    return this;
  }

  public Context addAttributesItem(Attribute attributesItem) {
    if (this.attributes == null) {
      this.attributes = new ArrayList<>();
    }
    this.attributes.add(attributesItem);
    return this;
  }

   /**
   * A repeated field of attributes associated with the operation.
   * @return attributes
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Attribute> getAttributes() {
    return attributes;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributes(List<Attribute> attributes) {
    this.attributes = attributes;
  }


  public Context data(Object data) {
    this.data = data;
    return this;
  }

   /**
   * Additional data associated with the context.
   * @return data
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getData() {
    return data;
  }


  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setData(Object data) {
    this.data = data;
  }


  /**
   * Return true if this Context object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Context context = (Context) o;
    return Objects.equals(this.tuples, context.tuples) &&
        Objects.equals(this.attributes, context.attributes) &&
        Objects.equals(this.data, context.data);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tuples, attributes, data);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Context {\n");
    sb.append("    tuples: ").append(toIndentedString(tuples)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `tuples` to the URL query string
    if (getTuples() != null) {
      for (int i = 0; i < getTuples().size(); i++) {
        if (getTuples().get(i) != null) {
          joiner.add(getTuples().get(i).toUrlQueryString(String.format("%stuples%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `attributes` to the URL query string
    if (getAttributes() != null) {
      for (int i = 0; i < getAttributes().size(); i++) {
        if (getAttributes().get(i) != null) {
          joiner.add(getAttributes().get(i).toUrlQueryString(String.format("%sattributes%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `data` to the URL query string
    if (getData() != null) {
      joiner.add(String.format("%sdata%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getData()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

