/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.6.1
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Expr;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * A list creation expression.  Lists may either be homogenous, e.g. &#x60;[1, 2, 3]&#x60;, or heterogeneous, e.g. &#x60;dyn([1, &#39;hello&#39;, 2.0])&#x60;
 */
@JsonPropertyOrder({
  CreateList.JSON_PROPERTY_ELEMENTS,
  CreateList.JSON_PROPERTY_OPTIONAL_INDICES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class CreateList {
  public static final String JSON_PROPERTY_ELEMENTS = "elements";
  private List<Expr> elements;

  public static final String JSON_PROPERTY_OPTIONAL_INDICES = "optionalIndices";
  private List<Integer> optionalIndices;

  public CreateList() { 
  }

  public CreateList elements(List<Expr> elements) {
    this.elements = elements;
    return this;
  }

  public CreateList addElementsItem(Expr elementsItem) {
    if (this.elements == null) {
      this.elements = new ArrayList<>();
    }
    this.elements.add(elementsItem);
    return this;
  }

   /**
   * The elements part of the list.
   * @return elements
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ELEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Expr> getElements() {
    return elements;
  }


  @JsonProperty(JSON_PROPERTY_ELEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElements(List<Expr> elements) {
    this.elements = elements;
  }


  public CreateList optionalIndices(List<Integer> optionalIndices) {
    this.optionalIndices = optionalIndices;
    return this;
  }

  public CreateList addOptionalIndicesItem(Integer optionalIndicesItem) {
    if (this.optionalIndices == null) {
      this.optionalIndices = new ArrayList<>();
    }
    this.optionalIndices.add(optionalIndicesItem);
    return this;
  }

   /**
   * The indices within the elements list which are marked as optional elements.  When an optional-typed value is present, the value it contains is included in the list. If the optional-typed value is absent, the list element is omitted from the CreateList result.
   * @return optionalIndices
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OPTIONAL_INDICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Integer> getOptionalIndices() {
    return optionalIndices;
  }


  @JsonProperty(JSON_PROPERTY_OPTIONAL_INDICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOptionalIndices(List<Integer> optionalIndices) {
    this.optionalIndices = optionalIndices;
  }


  /**
   * Return true if this CreateList object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateList createList = (CreateList) o;
    return Objects.equals(this.elements, createList.elements) &&
        Objects.equals(this.optionalIndices, createList.optionalIndices);
  }

  @Override
  public int hashCode() {
    return Objects.hash(elements, optionalIndices);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateList {\n");
    sb.append("    elements: ").append(toIndentedString(elements)).append("\n");
    sb.append("    optionalIndices: ").append(toIndentedString(optionalIndices)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `elements` to the URL query string
    if (getElements() != null) {
      for (int i = 0; i < getElements().size(); i++) {
        if (getElements().get(i) != null) {
          joiner.add(getElements().get(i).toUrlQueryString(String.format("%selements%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `optionalIndices` to the URL query string
    if (getOptionalIndices() != null) {
      for (int i = 0; i < getOptionalIndices().size(); i++) {
        joiner.add(String.format("%soptionalIndices%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
            URLEncoder.encode(String.valueOf(getOptionalIndices().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    return joiner.toString();
  }
}

