/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.6.1
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.AttributeDefinition;
import co.permify.sdk.model.EntityDefinitionReference;
import co.permify.sdk.model.PermissionDefinition;
import co.permify.sdk.model.RelationDefinition;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * The EntityDefinition message provides detailed information about a specific entity.
 */
@JsonPropertyOrder({
  EntityDefinition.JSON_PROPERTY_NAME,
  EntityDefinition.JSON_PROPERTY_RELATIONS,
  EntityDefinition.JSON_PROPERTY_PERMISSIONS,
  EntityDefinition.JSON_PROPERTY_ATTRIBUTES,
  EntityDefinition.JSON_PROPERTY_REFERENCES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class EntityDefinition {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_RELATIONS = "relations";
  private Map<String, RelationDefinition> relations = new HashMap<>();

  public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
  private Map<String, PermissionDefinition> permissions = new HashMap<>();

  public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
  private Map<String, AttributeDefinition> attributes = new HashMap<>();

  public static final String JSON_PROPERTY_REFERENCES = "references";
  private Map<String, EntityDefinitionReference> references = new HashMap<>();

  public EntityDefinition() { 
  }

  public EntityDefinition name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the entity, which follows a specific string pattern and has a maximum byte size.
   * @return name
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public EntityDefinition relations(Map<String, RelationDefinition> relations) {
    this.relations = relations;
    return this;
  }

  public EntityDefinition putRelationsItem(String key, RelationDefinition relationsItem) {
    if (this.relations == null) {
      this.relations = new HashMap<>();
    }
    this.relations.put(key, relationsItem);
    return this;
  }

   /**
   * Map of relation definitions within this entity. The key is the relation name, and the value is the RelationDefinition.
   * @return relations
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RELATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, RelationDefinition> getRelations() {
    return relations;
  }


  @JsonProperty(JSON_PROPERTY_RELATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRelations(Map<String, RelationDefinition> relations) {
    this.relations = relations;
  }


  public EntityDefinition permissions(Map<String, PermissionDefinition> permissions) {
    this.permissions = permissions;
    return this;
  }

  public EntityDefinition putPermissionsItem(String key, PermissionDefinition permissionsItem) {
    if (this.permissions == null) {
      this.permissions = new HashMap<>();
    }
    this.permissions.put(key, permissionsItem);
    return this;
  }

   /**
   * Map of permission definitions within this entity. The key is the permission name, and the value is the PermissionDefinition.
   * @return permissions
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PERMISSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, PermissionDefinition> getPermissions() {
    return permissions;
  }


  @JsonProperty(JSON_PROPERTY_PERMISSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPermissions(Map<String, PermissionDefinition> permissions) {
    this.permissions = permissions;
  }


  public EntityDefinition attributes(Map<String, AttributeDefinition> attributes) {
    this.attributes = attributes;
    return this;
  }

  public EntityDefinition putAttributesItem(String key, AttributeDefinition attributesItem) {
    if (this.attributes == null) {
      this.attributes = new HashMap<>();
    }
    this.attributes.put(key, attributesItem);
    return this;
  }

   /**
   * Map of attribute definitions within this entity. The key is the attribute name, and the value is the AttributeDefinition.
   * @return attributes
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, AttributeDefinition> getAttributes() {
    return attributes;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributes(Map<String, AttributeDefinition> attributes) {
    this.attributes = attributes;
  }


  public EntityDefinition references(Map<String, EntityDefinitionReference> references) {
    this.references = references;
    return this;
  }

  public EntityDefinition putReferencesItem(String key, EntityDefinitionReference referencesItem) {
    if (this.references == null) {
      this.references = new HashMap<>();
    }
    this.references.put(key, referencesItem);
    return this;
  }

   /**
   * Map of references indicating whether a string pertains to a relation, permission, or attribute.
   * @return references
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REFERENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, EntityDefinitionReference> getReferences() {
    return references;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReferences(Map<String, EntityDefinitionReference> references) {
    this.references = references;
  }


  /**
   * Return true if this EntityDefinition object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EntityDefinition entityDefinition = (EntityDefinition) o;
    return Objects.equals(this.name, entityDefinition.name) &&
        Objects.equals(this.relations, entityDefinition.relations) &&
        Objects.equals(this.permissions, entityDefinition.permissions) &&
        Objects.equals(this.attributes, entityDefinition.attributes) &&
        Objects.equals(this.references, entityDefinition.references);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, relations, permissions, attributes, references);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EntityDefinition {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    relations: ").append(toIndentedString(relations)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    references: ").append(toIndentedString(references)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `name` to the URL query string
    if (getName() != null) {
      joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `relations` to the URL query string
    if (getRelations() != null) {
      for (String _key : getRelations().keySet()) {
        if (getRelations().get(_key) != null) {
          joiner.add(getRelations().get(_key).toUrlQueryString(String.format("%srelations%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `permissions` to the URL query string
    if (getPermissions() != null) {
      for (String _key : getPermissions().keySet()) {
        if (getPermissions().get(_key) != null) {
          joiner.add(getPermissions().get(_key).toUrlQueryString(String.format("%spermissions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `attributes` to the URL query string
    if (getAttributes() != null) {
      for (String _key : getAttributes().keySet()) {
        if (getAttributes().get(_key) != null) {
          joiner.add(getAttributes().get(_key).toUrlQueryString(String.format("%sattributes%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `references` to the URL query string
    if (getReferences() != null) {
      for (String _key : getReferences().keySet()) {
        joiner.add(String.format("%sreferences%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
            getReferences().get(_key), URLEncoder.encode(String.valueOf(getReferences().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    return joiner.toString();
  }
}

