/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.6.1
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.Expr;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Represents an entry.
 */
@JsonPropertyOrder({
  Entry.JSON_PROPERTY_ID,
  Entry.JSON_PROPERTY_FIELD_KEY,
  Entry.JSON_PROPERTY_MAP_KEY,
  Entry.JSON_PROPERTY_VALUE,
  Entry.JSON_PROPERTY_OPTIONAL_ENTRY
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class Entry {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_FIELD_KEY = "fieldKey";
  private String fieldKey;

  public static final String JSON_PROPERTY_MAP_KEY = "mapKey";
  private Expr mapKey;

  public static final String JSON_PROPERTY_VALUE = "value";
  private Expr value;

  public static final String JSON_PROPERTY_OPTIONAL_ENTRY = "optionalEntry";
  private Boolean optionalEntry;

  public Entry() { 
  }

  public Entry id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Required. An id assigned to this node by the parser which is unique in a given expression tree. This is used to associate type information and other attributes to the node.
   * @return id
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Entry fieldKey(String fieldKey) {
    this.fieldKey = fieldKey;
    return this;
  }

   /**
   * The field key for a message creator statement.
   * @return fieldKey
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FIELD_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFieldKey() {
    return fieldKey;
  }


  @JsonProperty(JSON_PROPERTY_FIELD_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFieldKey(String fieldKey) {
    this.fieldKey = fieldKey;
  }


  public Entry mapKey(Expr mapKey) {
    this.mapKey = mapKey;
    return this;
  }

   /**
   * Get mapKey
   * @return mapKey
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MAP_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Expr getMapKey() {
    return mapKey;
  }


  @JsonProperty(JSON_PROPERTY_MAP_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMapKey(Expr mapKey) {
    this.mapKey = mapKey;
  }


  public Entry value(Expr value) {
    this.value = value;
    return this;
  }

   /**
   * Get value
   * @return value
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Expr getValue() {
    return value;
  }


  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(Expr value) {
    this.value = value;
  }


  public Entry optionalEntry(Boolean optionalEntry) {
    this.optionalEntry = optionalEntry;
    return this;
  }

   /**
   * Whether the key-value pair is optional.
   * @return optionalEntry
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OPTIONAL_ENTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getOptionalEntry() {
    return optionalEntry;
  }


  @JsonProperty(JSON_PROPERTY_OPTIONAL_ENTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOptionalEntry(Boolean optionalEntry) {
    this.optionalEntry = optionalEntry;
  }


  /**
   * Return true if this Entry object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Entry entry = (Entry) o;
    return Objects.equals(this.id, entry.id) &&
        Objects.equals(this.fieldKey, entry.fieldKey) &&
        Objects.equals(this.mapKey, entry.mapKey) &&
        Objects.equals(this.value, entry.value) &&
        Objects.equals(this.optionalEntry, entry.optionalEntry);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, fieldKey, mapKey, value, optionalEntry);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Entry {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    fieldKey: ").append(toIndentedString(fieldKey)).append("\n");
    sb.append("    mapKey: ").append(toIndentedString(mapKey)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    optionalEntry: ").append(toIndentedString(optionalEntry)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `fieldKey` to the URL query string
    if (getFieldKey() != null) {
      joiner.add(String.format("%sfieldKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFieldKey()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `mapKey` to the URL query string
    if (getMapKey() != null) {
      joiner.add(getMapKey().toUrlQueryString(prefix + "mapKey" + suffix));
    }

    // add `value` to the URL query string
    if (getValue() != null) {
      joiner.add(getValue().toUrlQueryString(prefix + "value" + suffix));
    }

    // add `optionalEntry` to the URL query string
    if (getOptionalEntry() != null) {
      joiner.add(String.format("%soptionalEntry%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOptionalEntry()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

